/***************************************************************************
                          kexchange.cpp  -  description
                             -------------------
    begin                : Mon Mar  4 11:43:40 EET 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qprinter.h>
#include <qpainter.h>
#include <qtabwidget.h>
#include <qclipboard.h>
#include <qdragobject.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qtimer.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kstddirs.h>
#include <ktip.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <ksystemtray.h>
#include <dcopclient.h>

// application specific includes
#include "kexchange.h"
#include "kexconvert.h"
#include "kextable.h"
#include "kexpacific.h"
#include "kexpreferences.h"

#define ID_STATUS_MSG 1
#define ID_REFRESH_MSG 2

#define UPDATE_INVERVAL 43200 //60*60*12 seconds
#define STATUS_LINGER 5000

KexchangeApp::KexchangeApp(QWidget* , const char* name):KMainWindow(0, name),DCOPObject("KExchange")
{
  config=kapp->config();
	preferences=NULL;
  if ( !kapp->dcopClient()->isRegistered() ) {
	  kapp->dcopClient()->registerAs(kapp->name());
  }
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initActions();
	
  readOptions();

  // Create widgets
	tabs=new QTabWidget(this);
	setCentralWidget(tabs);
	connect ( tabs,SIGNAL(currentChanged ( QWidget * )),this, SLOT (slotTabChanged( QWidget * )) );

	data=new KExPacific(this);
  connect (data, SIGNAL(status ( int, const QString & ) ), this, SLOT (slotDataStatus ( int, const QString & ) ) );
  connect (data, SIGNAL(dataReady(bool) ), this, SLOT (slotDataReady(bool) ) );

	convert=new KExConvert(this);
	convert->setOptions(data,showEuro);
	convert->setExchange(config->readEntry("ToCurrency", "DEM"),config->readEntry("FromCurrency", "EUR"));
	tabs->addTab(convert,i18n("Convert currency"));	

	table=new KExTable(this);
	table->setOptions(data,showEuro);
	table->setBase(config->readEntry("BaseCurrency", "EUR"));
	table->setUnitBase(config->readBoolEntry("UnitBase", true));
	tabs->addTab(table,i18n("Exchange rates"));

  statusTimer = new QTimer(this);
  connect( statusTimer, SIGNAL(timeout()), this, SLOT(slotRefreshMsg()) );
  updateTimer = new QTimer(this);
  connect( updateTimer, SIGNAL(timeout()), this, SLOT(slotViewRefresh()) );

	KTipDialog::showTip (this,locate( "datadir","tips"));
	slotRefreshMsg();
	startUpdateTimer();

	tray=new KSystemTray(this);
	tray->setPixmap(kapp->miniIcon());

  config->setGroup("General Options");
	if (config->readBoolEntry("Docked", false))
    dock();
	else
		show();
}

KexchangeApp::~KexchangeApp() {
	delete data;
}

void KexchangeApp::initActions()
{
//  filePrint = KStdAction::print(this, SLOT(slotFilePrint()), actionCollection());
	fileSave = KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
  editCopy = KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection());
  editPaste = KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection());
  viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
  viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());
	editSwitch = new KAction(i18n("Switch"), "rotate", Key_S, this, SLOT(slotEditSwitch()), actionCollection(), "edit_switch");
	viewRefresh = new KAction(i18n("Refresh"), "reload", Key_R, this, SLOT(slotViewRefresh()), actionCollection(), "view_refresh");
  setPreferences = KStdAction::preferences( this, SLOT( slotPreferences() ), actionCollection() );
  setAccels = KStdAction::keyBindings( this, SLOT( slotConfAccels() ), actionCollection() );
  setToolbar = KStdAction::configureToolbars( this, SLOT( slotEditToolbars() ), actionCollection() );
	helpTip = new KAction(i18n("Tip of the Day"),"idea",0, this, SLOT(slotShowTip()), actionCollection(), "help_tip");

//  filePrint ->setStatusText(i18n("Prints out the currency rates table"));
  fileQuit->setStatusText(i18n("Quits the application"));
  fileSave->setStatusText(i18n("Saves the exchange rates table in CSV format"));
  editCopy->setStatusText(i18n("Copies the converted currency amount to the clipboard"));
  editPaste->setStatusText(i18n("Pastes the clipboard contents to currency conversion field"));
  editSwitch->setStatusText(i18n("Switch from and to currencies"));
  viewRefresh->setStatusText(i18n("Refresh currency data from the net"));
  viewToolBar->setStatusText(i18n("Enable/disable the toolbar"));
  viewStatusBar->setStatusText(i18n("Enable/disable the statusbar"));

  // use the absolute path to your kexchangeui.rc file for testing purpose in createGUI();
  createGUI();
}

void KexchangeApp::initStatusBar()
{
  statusBar()->insertItem(i18n("Ready"), ID_STATUS_MSG, 1,false);
	statusBar()->setItemAlignment (ID_STATUS_MSG, AlignLeft);
  statusBar()->insertItem("", ID_REFRESH_MSG, 0,false);
	statusBar()->setItemAlignment (ID_REFRESH_MSG, AlignRight);
}

void KexchangeApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("GeometryPos",pos());
  config->writeEntry("Show Toolbar", viewToolBar->isChecked());
  config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
	config->writeEntry("FromCurrency", convert->getFrom());
	config->writeEntry("ToCurrency", convert->getTo());
	config->writeEntry("BaseCurrency", table->getBase());
	config->writeEntry("UnitBase", table->getUnitBase());
	config->writeEntry("ShowEuro", showEuro);
	config->writeEntry("AutoUpdate", autoUpdate);
	config->writeEntry("LastUpdate", lastUpdate);
	config->writeEntry("Dockable", dockable);
	config->writeEntry("Docked", dockable && isHidden());
}

void KexchangeApp::readOptions()
{
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();

  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);

	// Restore options
	showEuro=config->readBoolEntry("ShowEuro",true);
	autoUpdate=config->readBoolEntry("AutoUpdate",false);
	QDateTime deftime=QDateTime(QDate(1900,1,1));
	lastUpdate=config->readDateTimeEntry("LastUpdate",&deftime);
	dockable=config->readBoolEntry("Dockable",true);

	// Restore size & position
	QSize defsize(450,400);
  QSize size=config->readSizeEntry("Geometry", &defsize);
  QPoint pos=config->readPointEntry("GeometryPos");
  resize(size);
	if (!pos.isNull())
	  move(pos);
}

bool KexchangeApp::queryExit()
{
  saveOptions();
  return true;
}
void KexchangeApp::hideEvent ( QHideEvent * ) {
	if (isMinimized() && dockable) {
    dock();
	}
}
void KexchangeApp::dock() {
	tray->show();	
	hide();
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////
void KexchangeApp::slotFileSave() {
	QString filename = KFileDialog::getSaveFileName(QString::null,QString::null,this);
	if (filename) {
		QFile file(filename);
		if (file.exists()) {
			if (KMessageBox::questionYesNo (this,i18n("Do you want to overwrite existing file?"),i18n("File exists"))!=KMessageBox::Yes)
				return;
		}
		if (file.open(IO_WriteOnly) ) {
	    QTextStream t( &file );
			QStringList list=data->getCurrencies(showEuro);
			KExData r;
		  t << i18n("Currency") << ";" << i18n("Code") << ";" << i18n("Exchange rate")+" (";
			if (table->getUnitBase())			
				t << i18n("unit")+"/"+table->getBase();
			else
				t << table->getBase()+"/"+i18n("unit");
			t << ")\n";
		  for ( QStringList::ConstIterator it = list.begin(); it != list.end(); ++it ) {
			  t << data->getCurrencyName(*it) << ";";
			  t << *it << ";";
				if (table->getUnitBase())
					r=data->getRate(*it,table->getBase());
				else
					r=data->getRate(table->getBase(),*it);
			  t << data->round(r.rate) << "\n";
			}
		  statusBar()->message(i18n("Data stored to the file."),STATUS_LINGER);
	  } else {
     	KMessageBox::error(this,i18n("Cannot write to the file."));
		}
	}
}
void KexchangeApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));
 /*
  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }
*/
  slotStatusMsg(i18n("Ready"));
}

void KexchangeApp::slotFileQuit()
{
  saveOptions();
  kapp->quit();
}

void KexchangeApp::slotEditCopy()
{
	kapp->clipboard()->setData(new QTextDrag(convert->getOutput()));
}

void KexchangeApp::slotEditPaste()
{
  QString text;
  if ( QTextDrag::decode(kapp->clipboard()->data(), text) )
        convert->setInput(text);
}
void KexchangeApp::slotEditSwitch() {
	convert->setExchange(convert->getFrom(),convert->getTo());
}
void KexchangeApp::slotViewRefresh() {
	viewRefresh->setEnabled(false);
	data->refresh();
}
void KexchangeApp::slotViewToolBar()
{
  // turn Toolbar on or off
  if(!viewToolBar->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }		
}

void KexchangeApp::slotViewStatusBar()
{
  //turn Statusbar on or off
  if(!viewStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }
}
void KexchangeApp::slotConfAccels()
{
  KKeyDialog::configureKeys( actionCollection(), xmlFile() );
}
void KexchangeApp::slotEditToolbars()
{
  KEditToolbar dlg( actionCollection() );
  if ( dlg.exec() )
    createGUI();
}
void KexchangeApp::slotPreferences()
{
	if (preferences==NULL)
		preferences=new KExPreferences(this);
	preferences->reset();
	preferences->show();
}
void  KexchangeApp::slotShowTip() {
	KTipDialog::showTip (this,locate( "datadir","tips"),true);
}
void KexchangeApp::slotTabChanged( QWidget * w) {
 	if (w==convert) {
   	editSwitch->setEnabled(true);
   	editCopy->setEnabled(true);
   	editPaste->setEnabled(true);
	}
	if (w==table) {
   	editSwitch->setEnabled(false);
   	editCopy->setEnabled(false);
   	editPaste->setEnabled(false);
	}
}
void KexchangeApp::slotDataReady(bool ok) {
	slotReset();
	viewRefresh->setEnabled(true);
	if (ok) {
		lastUpdate=QDateTime::currentDateTime();
		startUpdateTimer();
	}
	statusTimer->start( STATUS_LINGER, TRUE );
}
void KexchangeApp::slotReset() {
	QString from=convert->getFrom();
	QString to=convert->getTo();
	QString base=table->getBase();
	convert->setOptions(data,showEuro);
	convert->setExchange(to,from);
	table->setOptions(data,showEuro);	
	table->setBase(base);
}
void KexchangeApp::slotDataStatus(int s, const QString &text) {
  statusBar()->message(text);
}
void KexchangeApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}
void KexchangeApp::slotRefreshMsg()
{
	QString text=i18n("Last update:");
	if (lastUpdate.date()==QDate(1900,1,1))
		text+=" "+i18n("Never");
	else
		text+=" "+KGlobal::locale()->formatDateTime(lastUpdate,true);
  statusBar()->changeItem(text, ID_REFRESH_MSG);
}
void KexchangeApp::startUpdateTimer() {
	if (autoUpdate) {
		long time=QDateTime::currentDateTime().secsTo(lastUpdate.addSecs(UPDATE_INVERVAL))*1000;
		if (time<0)
			time=0;
		updateTimer->start(time, true );
	} else
		updateTimer->stop();
}
