/***************************************************************************
                          kexconvert.h  -  description
                             -------------------
    begin                : Mon Mar 4 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEXCONVERT_H
#define KEXCONVERT_H

#include <qwidget.h>
#include <qlabel.h>

#include <klineedit.h>

/**
  *@author Tero Favorin
  */
class KLocale;
class KComboBox;
class KExDataSource;
class KExSource;

class KExConvert : public QWidget{
Q_OBJECT
public: 
	KExConvert(QWidget * parent=0, const char * name=0, WFlags f=0);
	~KExConvert();
	void setOptions(KExDataSource *d, bool e);
	void setExchange(QString to, QString from);
	QString getFrom();
	QString getTo();
	QString getOutput() {return output->text();}
	void setInput(QString s);

public slots:
	void updateRate( int index );
	void update(const QString&);

private:
	KLocale *locale;
	KExDataSource *data;
	double exrate;
	bool oldeuro;
	QStringList list;

	QLabel *from;
	QLabel *to;
	KComboBox *fromCombo;
	KComboBox *toCombo;
	KLineEdit *input;
	QLabel *fromCur;
	QLabel *toCur;
	QLabel *output;
	QLabel *rateText2;
	QLabel *rateDate;
	QLabel *rate;
	KExSource *source;
};

#endif
