/***************************************************************************
                          optconf.cpp  -  description
                             -------------------
    begin                : Tue May 2 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          optconf.cpp  -  description
                             -------------------
    begin                : Sun Jan 23 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "optconf.h"

OptConf::OptConf(QWidget *parent, const char *name )
		: QFrame(parent,name)
{
	output = true;

	nooutputBox = new QCheckBox(i18n("Don't show messages"), this);
	nooutputBox->setGeometry(8,8,200,20);
	connect(nooutputBox, SIGNAL(clicked()), this, SLOT(noOutput()));

	retryBox = new QCheckBox(i18n("Retry broken Downloads"), this);
	retryBox->setGeometry(8,28,200,20);
	connect(retryBox, SIGNAL(clicked()), this, SLOT(setRetrys()));

	numRetryLab = new QLabel(i18n("Number of retries"), this);
	numRetryLab->setGeometry(38,48,100,20);

	numRetryBox = new QSpinBox(1,9999,1,this);
	numRetryBox->setGeometry(148,48,50,20);
	numRetryBox->setEnabled(false);

	waitRetryLab = new QLabel(i18n("wait seconds"), this);
	waitRetryLab->setGeometry(38,68,100,20);

	waitRetryBox = new QSpinBox(0,999,1,this);
	waitRetryBox->setGeometry(148,68,50,20);
	waitRetryBox->setEnabled(false);

	recursiveBox = new QCheckBox(i18n("Get files recursive"), this);
	recursiveBox->setGeometry(8,88,200,20);
	connect(recursiveBox, SIGNAL(clicked()), this, SLOT(activateRecursive()));
	QToolTip::add(recursiveBox, i18n("Attention: 0 means unlimited !"));

	levLab = new QLabel(i18n("Number of Levels:"), this);
	levLab->setGeometry(38,108,100,20);

	levSpBox = new QSpinBox(0,999,1,this);
	levSpBox->setGeometry(148,108,50,20);
	levSpBox->setEnabled(false);
	QToolTip::add(levSpBox, i18n("Attention: 0 means unlimited !"));
	
	timeoutBox = new QCheckBox(i18n("Set timeout for reading"), this);
	timeoutBox->setGeometry(8,128,200,20);
	connect(timeoutBox, SIGNAL(clicked()),this, SLOT(setTimeout()));
	
	timeoutLab = new QLabel(i18n("seconds:"), this);
	timeoutLab->setGeometry(38,148,100,20);
	
	timeoutSpBox = new QSpinBox(1,999,1,this);
	timeoutSpBox->setGeometry(148,148,50,20);
	timeoutSpBox->setEnabled(false);

	quotaBox = new QCheckBox(i18n("Set retrieval quota"), this);
	quotaBox->setGeometry(8,168,200,20);
	connect(quotaBox, SIGNAL(clicked()),this, SLOT(setQuota()));

	quotaLab = new QLabel(i18n("Max. MBytes"), this);
	quotaLab->setGeometry(38,188,100,20);

	quotaSpBox = new QSpinBox(1,9999,1,this);
	quotaSpBox->setGeometry(148,188,50,20);
	quotaSpBox->setEnabled(false);

	logBox = new QCheckBox(i18n("Write Log-File"), this);
	logBox->setGeometry(258,3,100,20);

	noclubBox = new QCheckBox(i18n("Don't overwrite existing files"), this);
	noclubBox->setGeometry(258,23,180,20);

	timestampBox = new QCheckBox(i18n("Don't get files, older than the existing files"), this);
	timestampBox->setGeometry(258,43,245,20);
	
	folderBox = new QCheckBox(i18n("Don't create directorys"), this);
	folderBox->setGeometry(258,63,183,20);
	connect(folderBox, SIGNAL(clicked()), this, SLOT(checkDirOpt()));
	
	nohostBox = new QCheckBox(i18n("Don't create host directorys"), this);
	nohostBox->setGeometry(258,83,215,20);
	connect(nohostBox, SIGNAL(clicked()), this, SLOT(checkDirOpt()));

	forcedirBox = new QCheckBox(i18n("Force the creation of directorys"), this);
	forcedirBox->setGeometry(258,103,210,20);
	connect(forcedirBox, SIGNAL(clicked()), this, SLOT(checkDirOpt()));

	serveranswerBox = new QCheckBox(i18n("Show the servers answers"), this);
	serveranswerBox->setGeometry(258,125,170,20);
	
	nodnsBox = new QCheckBox(i18n("Don't dns-lookup hosts"), this);
	nodnsBox->setGeometry(258,145,180,20);
	
	cacheBox = new QCheckBox(i18n("Allow server-cached data"), this);
	cacheBox->setGeometry(258,165,200,20);

	followftpBox = new QCheckBox(i18n("Follow FTP-Links from HTML documents"), this);
	followftpBox->setGeometry(258,185,270,20);

	spiderBox = new QCheckBox(i18n("Don't download anything"), this);
	spiderBox->setGeometry(8,218,160,20);
	
	convlinkBox = new QCheckBox(i18n("Convert non-relative links to relative links"), this);
	convlinkBox->setGeometry(258,205,255,20);
	
	passFtpBox = new QCheckBox(i18n("Use passive ftp-mode"), this);
	passFtpBox->setGeometry(258,225,220,15);
}

OptConf::~OptConf()
{
}

void OptConf::activateRecursive()
{
	if ( recursiveBox->isChecked() ) {
		levSpBox->setEnabled(true);
	} else {
		levSpBox->setEnabled(false);
	}
}

void OptConf::setRetrys()
{
	if ( retryBox->isChecked() ) {
		numRetryBox->setEnabled(true);
		waitRetryBox->setEnabled(true);
	} else {
		numRetryBox->setEnabled(false);
		waitRetryBox->setEnabled(false);
}
}

void OptConf::setTimeout()
{
	if ( timeoutBox->isChecked() ) {
		timeoutSpBox->setEnabled(true);
	} else {
		timeoutSpBox->setEnabled(false);
	}
}

void OptConf::setQuota()
{
	if ( quotaBox->isChecked() ){
		quotaSpBox->setEnabled(true);
	}else {
		quotaSpBox->setEnabled(false);
	}
}

void OptConf::checkDirOpt()
{
	if ( ( folderBox->isChecked()) || (nohostBox->isChecked()) ) {
		forcedirBox->setChecked(false);
		forcedirBox->setEnabled(false);
		nohostBox->setEnabled(true);
		folderBox->setEnabled(true);
	} else if ( forcedirBox->isChecked() ) {
		forcedirBox->setEnabled(true);
		folderBox->setChecked(false);
		folderBox->setEnabled(false);
		nohostBox->setChecked(false);
		nohostBox->setEnabled(false);
	}
	if ( ( !folderBox->isChecked()) && ( !nohostBox->isChecked()) ) {
		forcedirBox->setEnabled(true);
	}
	if ( !forcedirBox->isChecked() ) {
		nohostBox->setEnabled(true);
		folderBox->setEnabled(true);
	}
}

void OptConf::noOutput()
{
	if ( nooutputBox->isChecked() )
		output = false;
	else
		output = true;
}