/***************************************************************************
                          wizpage3.cpp  -  description
                             -------------------
    begin                : Tue Feb 8 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "wizpage3.h"

WizPage3::WizPage3(QWidget *parent, const char *name )
		: QFrame(parent,name)
{
	addNumBak = 0;
	hasSiteList = false;
	mirFrame = new QFrame(this);
	mirFrame->setGeometry(1,1,438,248);
	mirFrame->hide();

	fileFrame = new QFrame(this);
	fileFrame->setGeometry(1,1,438,248);
	fileFrame->hide();

	listFrame = new QFrame(this);
	listFrame->setGeometry(1,1,438,248);
	listFrame->hide();
	mirrorSite();
	singleFile();
	siteList();
}

WizPage3::~WizPage3()
{
}

void WizPage3::mirrorSite()
{
	QLabel *lab = new QLabel(i18n("Mirror a whole site, for Off-line Browsing"), mirFrame);
	lab->setGeometry(5,5,435,15);
	lab->setAlignment(AlignCenter);
	lab->setFont(QFont("helvetica", 14, QFont::Bold));

	QLabel *infoLab = new QLabel(i18n("To create an Off-line Browsing project, you'll have to give\n"
			"the starting URL, including subdirectorys (Example: http://www.kpage.de/en/kwebget)"), mirFrame);
	infoLab->setFont(QFont("helvetica", 10));
	infoLab->setGeometry(5,35,435,30);

	QLabel *startLab = new QLabel(i18n("Starting URL :"), mirFrame);
	startLab->setGeometry(5,75,100,20);

	protBox[0] = new QComboBox(mirFrame);
	protBox[0]->insertItem("http://",0);
	protBox[0]->insertItem("ftp://",1);
	protBox[0]->setGeometry(85,73,60,24);
	connect(protBox[0], SIGNAL(activated(int)), this, SLOT(setAnon(int)));

	urlLine[0] = new MyDropLineEdit(mirFrame);
	urlLine[0]->setGeometry(150,75,250,20);

	QLabel *questLab = new QLabel(i18n("Ftpsites, and some Websites require a password.\n"
				"Does your starting URL require a password ?\n"), mirFrame);
	questLab->setGeometry(5,115,435,40);

	loginBut[0] = new QCheckBox(i18n("Yes"), mirFrame);
	loginBut[0]->setGeometry(5,160,50,20);
	connect(loginBut[0], SIGNAL(clicked()), this, SLOT(enableLogin()));

	anonBut[0] = new QCheckBox(i18n("Use anonymous Login"), mirFrame);
	anonBut[0]->setGeometry(70,160,150,20);
	anonBut[0]->setFont(QFont("helvetica",10));
	connect(anonBut[0], SIGNAL(clicked()), this, SLOT(setAnon()));
	anonBut[0]->hide();

	QLabel *userLab = new QLabel(i18n("Username :"), mirFrame);
	userLab->setGeometry(5,180,70,15);
	
	QLabel *passLab = new QLabel(i18n("Password :"), mirFrame);
	passLab->setGeometry(5,200,70,15);

	userLine[0] = new QLineEdit(mirFrame);
	userLine[0]->setGeometry(75,180,200,20);
	userLine[0]->setEnabled(false);

	passLine[0] = new QLineEdit(mirFrame);
	passLine[0]->setGeometry(75,200,200,20);
	passLine[0]->setEnabled(false);
	passLine[0]->setEchoMode(QLineEdit::Password);
}

void WizPage3::singleFile()
{
	QLabel *lab = new QLabel(i18n("Download a single file from a known site"), fileFrame);
	lab->setGeometry(5,5,435,17);
	lab->setAlignment(AlignCenter);
	lab->setFont(QFont("helvetica", 14, QFont::Bold));

	QLabel *infoLab = new QLabel(i18n("To download a single file, you have to enter the URL(with subdirectorys),"
			"and the filename."), fileFrame);
	infoLab->setFont(QFont("helvetica",10));
	infoLab->setGeometry(5,35,435,15);

	QLabel *exmplLab = new QLabel(i18n("(Example: URL: http://www.kpage.de/en/kwebget/download"
				" |  File: kwebget-0.3.tar.bz2)"), fileFrame);
	exmplLab->setFont(QFont("helvetica",10));
	exmplLab->setGeometry(5,52,435,14);

	QLabel *startLab = new QLabel(i18n("Starting URL :"), fileFrame);
	startLab->setGeometry(5,75,100,20);

	protBox[1] = new QComboBox(fileFrame);
	protBox[1]->insertItem("http://",0);
	protBox[1]->insertItem("ftp://",1);
	protBox[1]->setGeometry(85,74,60,22);
	connect(protBox[1], SIGNAL(activated(int)), this, SLOT(setAnon(int)));

	urlLine[1] = new MyDropLineEdit(fileFrame);
	urlLine[1]->setGeometry(150,75,250,20);

	QLabel *fileLab = new QLabel(i18n("Filename:"), fileFrame);
	fileLab->setGeometry(5,95,100,20);

	fileLine[1] = new MyDropLineEdit(fileFrame);
	fileLine[1]->setGeometry(85,95,200,20);

	QLabel *questLab = new QLabel(i18n("Ftpsites, and some Websites require a password.\n"
				"Does your starting URL require a password ?\n"), fileFrame);
	questLab->setGeometry(5,125,435,40);

	loginBut[1] = new QCheckBox(i18n("Yes"), fileFrame);
	loginBut[1]->setGeometry(5,170,50,20);
	connect(loginBut[1], SIGNAL(clicked()), this, SLOT(enableLogin()));

	anonBut[1] = new QCheckBox(i18n("Use anonymous Login"), fileFrame);
	anonBut[1]->setGeometry(70,170,150,20);
	anonBut[1]->setFont(QFont("helvetica",10));
	connect(anonBut[1], SIGNAL(clicked()), this, SLOT(setAnon()));
	anonBut[1]->hide();

	QLabel *userLab = new QLabel(i18n("Username :"), fileFrame);
	userLab->setGeometry(5,190,70,15);
	
	QLabel *passLab = new QLabel(i18n("Password :"), fileFrame);
	passLab->setGeometry(5,210,70,15);

	userLine[1] = new QLineEdit(fileFrame);
	userLine[1]->setGeometry(75,190,200,20);
	userLine[1]->setEnabled(false);

	passLine[1] = new QLineEdit(fileFrame);
	passLine[1]->setGeometry(75,210,200,20);
	passLine[1]->setEnabled(false);
	passLine[1]->setEchoMode(QLineEdit::Password);
}

void WizPage3::siteList()
{
	QLabel *lab = new QLabel(i18n("Mirror or Download more than one site or file"), listFrame);
	lab->setGeometry(5,5,435,17);
	lab->setAlignment(AlignCenter);
	lab->setFont(QFont("helvetica", 14, QFont::Bold));

	QString txt, txt2;
	txt = (i18n("You first have to enter the URL's of the sites and files, you'ld like to download.\n"
			"By clicking the 'SiteList'-Button, a new window will open,\n"
			"where you can enter the URL's" ));
	txt2 = (i18n("If the site, you'ld like to connect to requires a password, please read the helptext,\n"
			"that is avaible in the new window !"));
	
	QLabel *infoLab = new QLabel(txt, listFrame);
	infoLab->setGeometry(5,45,435,55);

	QLabel *exmplLab = new QLabel(txt2 , listFrame);
	exmplLab->setFont(QFont("helvetica",10));
	exmplLab->setGeometry(5,100,435,30);

	sitelistBut = new MyPushButton(i18n("SiteList"), listFrame);
	sitelistBut->setGeometry(177,160,90,25);
	connect(sitelistBut, SIGNAL(clicked()), this, SLOT(openSiteList()));
}

void WizPage3::enableLogin()
{
	for ( int i=0; i <= 2 ; i++ ) {
	  if ( this->sender() == loginBut[i] ) {
		int tmp = protBox[i]->currentItem();
		if (( loginBut[i]->isChecked() )&&( tmp == 1 )) {
			passLine[i]->setEnabled(true);
			userLine[i]->setEnabled(true);
			userLine[i]->setFocus();
			anonBut[i]->show();
		} else if (( loginBut[i]->isChecked() )&&( tmp != 1 )) {
			passLine[i]->setEnabled(true);
			userLine[i]->setEnabled(true);
			passLine[i]->setText("");
			userLine[i]->setText("");
			userLine[i]->setFocus();
			anonBut[i]->hide();
		} else {
			passLine[i]->setEnabled(false);
			userLine[i]->setEnabled(false);
			passLine[i]->setText("");
			userLine[i]->setText("");
			anonBut[i]->setChecked(false);
			anonBut[i]->hide();
		}
	  }
	}
}

void WizPage3::setAnon()
{
	for ( int i=0 ; i <= 2; i++ ) {
	  if ( this->sender() == anonBut[i] ) {
		if ( anonBut[i]->isChecked() ) {
			userLine[i]->setText("anonymous");
			passLine[i]->setEchoMode(QLineEdit::Normal);
			passLine[i]->setEnabled(false);
			userLine[i]->setEnabled(false);
			passLine[i]->selectAll();
		} else {
			userLine[i]->setText("");
			passLine[i]->setText("");
			passLine[i]->setEchoMode(QLineEdit::Password);
			userLine[i]->setEnabled(true);
			passLine[i]->setEnabled(true);
			userLine[i]->setFocus();
		}
	  }
	}
}

void WizPage3::setAnon(int index)
{
	for ( int i=0 ; i <= 2; i++ ) {
	  if ( this->sender() == protBox[i] ) {
		if (( index )&&( loginBut[i]->isChecked() )) {
			anonBut[i]->show();
		} else {
			anonBut[i]->hide();
		}
		if (( !index )&&( anonBut[i]->isChecked() )) {
			userLine[i]->setText("");
			passLine[i]->setText("");
			passLine[i]->setEchoMode(QLineEdit::Password);
			if ( loginBut[i]->isChecked() ) {
				userLine[i]->setEnabled(true);
				passLine[i]->setEnabled(true);
			}
			anonBut[i]->setChecked(false);
			userLine[i]->setFocus();
		}
	  }
	}
}

void WizPage3::openSiteList()
{
	if ( !hasSiteList ) {
		listWidg = new ListEnterDialog(this, "ListEnterDialog", true,0);
		listWidg->resize(500,300);
		listWidg->setMinimumSize(320,150);
		connect(listWidg->applyBut, SIGNAL(clicked()), this, SLOT(listApplyed()));
		connect(listWidg, SIGNAL(canceled()), this, SLOT(listCanceled()));
		listWidg->show();
		hasSiteList = true;
	} else {
		backupList();
		listWidg->show();
	}
}

void WizPage3::listApplyed()
{
	QString tmp, txt;
	bool emptStr = false;
	for ( int i=0; i <= listWidg->addNum ; i++) {
		tmp = listWidg->siteLine[i]->text();
		if ( !tmp.isEmpty() )
			emptStr = true;
	}
	if ( !emptStr ) {
		QMessageBox::warning( this, i18n("Empty Lines"),
			i18n("Please enter some sites, to download from !"));
		return;
	}
	listWidg->hide();
	emit listCompleted();
}

void WizPage3::listCanceled()
{
	if ( hasSiteList ) {
	// Now I have to restore the old entrys in the list...
	listWidg->rmAllCancel();
	for ( int i=0; i <= addNumBak ; i++ ) {
		if ( i >= 1)
			listWidg->addSite();
		listWidg->protChoose[i]->setCurrentItem(protbak[i]);
		listWidg->siteLine[i]->setText(sitebak[i]);
		listWidg->ftpBox[i]->setChecked(anonbak[i]);
		if ( protbak[i] )
			listWidg->ftpBox[i]->show();
	}
	}
}

void WizPage3::backupList()
{
	for ( int i=0; i <= listWidg->addNum ; i++ ) {
		protbak[i] = listWidg->protChoose[i]->currentItem();
		anonbak[i] = listWidg->ftpBox[i]->isChecked();
		sitebak[i] = listWidg->siteLine[i]->text();
		addNumBak = listWidg->addNum;
	}
}