/***************************************************************************
                          kwebget.h  -  description
                             -------------------
    begin                : Son Jan 16 14:32:43 CET 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWEBGET_H
#define KWEBGET_H

#include <kapp.h>
#include <ktmainwindow.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <ksimpleconfig.h>
#include <kprocess.h>

#include <qwidget.h>
#include <qpopupmenu.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qtabdialog.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qaccel.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qtooltip.h>
#include <qtimer.h>
#include <qlistview.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qregexp.h>
#include <qdatetime.h>

#include "mainconf.h"
#include "optconf.h"
#include "fileconf.h"
#include "passconf.h"
#include "proxyconf.h"
#include "scheduleconf.h"
#include "outputwidget.h"
#include "prefdialog.h"
#include "domainconf.h"
#include "wizard/kwgwizard.h"
#include "mydialog.h"
#include "kscheduleicon.h"
#include "statusdialog.h"

class KWebGet : public KTMainWindow
{
  Q_OBJECT 
  public:
    /** construtor */
    KWebGet();
    /** destructor */
    ~KWebGet();

    /** StartApp **/
    void startApp();

	/** Startscreen **/
    void startView();
    /** Used Background Pixmaps **/
    QPixmap welPic, bgPic, bg2Pic;
	QPushButton *fileaddBut;
	KWGWizard *wizard;

  private:
  	KConfig *appConfig;
  	QDir projDir;
  	MyDialog *wizQuest;
  	QAccel *acc;
  	QString wgetBin, ftpEmail, wgetopt;
  	int numself, scheduleTime, cnt, scheduleCount, schedNums, afterHour,
  		schedHour, schedMinute;
	char *iBuffer;
	// Default Proxy ?
	bool defhpr, deffpr, htprlog, ftprlog, scheduling;
    /** Widget for the startscreen **/
	QWidget *startShow;
	/** Everything needed for the menuBar **/
    void initMenuBar();
  	QPopupMenu *file_menu, *wiz_menu, *options_menu, *help_menu;
	/** Everything needed for the toolBar **/
	void initToolBar();
	QPushButton *newBut, *openBut, *saveBut, *prevBut, *wizBut;
	PrefDialog *prefDialog;
	
	void wizStartQuest();

	/** Variables for the menu- and toolBar **/	
	int ID_OPEN, ID_NEW, ID_FILE_SAVE,ID_FILE_SAVE_AS, ID_FILE_QUIT,
		ID_PREF, ID_CLOSE, ID_WIZARD, start;
	// Everything needed to save the project
	QString home, httpProxy, ftpProxy, httpPrLogin, httpPrPass, email, emailUse;
	QString defHttpProxyAdr, defHttpProxyPrt, defHttpProxyUsr, defHttpProxyPss,
			defFtpProxyAdr, defFtpProxyPrt;

	QString saveName;
	KFileDialog *saveDialog;
	KSimpleConfig *config;
	int appChanged();
	
	// Everything needed to open an existing project
	KFileDialog *openDialog;
	
	// The Close-Event
	void closeEvent(QCloseEvent *);

	// The mainScreen
	void initMainView();
	QWidget *mainConf, *optConf, *fileConf, *domainConf, *passConf,
			*proxyConf, *scheduleConf;
  	QTabDialog *mainTab ;
	// General-Menu
  	void setMainConf();
  	  MainConf *mainFrame;
  	  QString projName,	prot;
	// Options-Menu
	void setOptConf();
	  OptConf *optFrame;
  	// FileType-Menu
  	void setFileConf();
  	  FileConf *fileFrame;
  	  QButtonGroup *fileBox;
  	  QRadioButton *getAllTypes, *getSelTypes;
  	
  	// Domain-Menu
  	void setDomainConf();
  	  DomainConf *domainFrame;
  	  QButtonGroup *domainBox;
  	  QRadioButton *getAllDomains, *getSelDomains;
  	
  	// Password-Menu
  	void setPassConf();
  	  PassConf *passFrame;

  	// Proxy-Menu
  	void setProxyConf();
  	  ProxyConf *proxyFrame;

  	// Schedule-Menu
  	void setScheduleConf();
	ScheduleConf *scheduleFrame;

  	// The Scheduler
		void timerEvent(QTimerEvent *);
		void prepareScheduler();
		void startScheduler();
		int checkMinute();
		int checkHour();
		int checkDay();
		int checkMonth();
		KScheduleIcon *schedIcon;
		int days[8];
		int schedMonth;
		StatusDialog *statusDialog;

  	// Everything to call wget ...
  	  QFile logFile, accesstmp;
  	  const char* term;
  	  KShellProcess *wget, *turnOnProxy;
  	  OutputWidget *outputWidget;
  	  bool killed, writeLog, recBool, scrollIt, wizOnStartup;
  	  QString getWgetOptions();
	  void writeListFile();

  private slots:
    // Funktion, that is called after the startscreen
  	  void timerStoped();
    // Function, to initialize the MainScreen
    void initView();
    // Function to exit the Application
	void quitApp();
	void newProject();
	int closeProject();
	void getAllFileTypes();
	void getALLDomains();

	// Gets the Path, to where to save the downloaded files
	void setCaptionText(const char*);
	void enableFileTypes();
	void disableFileTypes();
	void getProt(int);
	void setFtpAnon();
	int testConf();
	int startMirror();
	void writeConfig();
	void openFile();
	void saveFileAs();
	void prefMenu();
	  void prefOkApply();
	  void prefOk();
	  void prefCancel();

	void startWGet();
	void giveBackStdoutErr(KProcess *, char *, int);
	void dismissWget();
	void cancelWget();
	void wgetReady(KProcess *);
	void autoScroll();

	void startWizard();
	void showWizQuestSave();
	void showWizQuestApply();
	void showWizQuestCancel();
	void quitWizard();
	void getWizSet();

	void letItRoll();

	void cancelScheduler();
	void showSchedInfo();
	void showSchedOutput();
};

#endif