/***************************************************************************
                          options.cpp  -  description
                             -------------------
    begin                : Wed Apr 19 2000
    copyright            : (C) 2000 by Mickal Marchand
    email                : MikMak@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "options.h"

extern bool beeper;
extern bool loguer;
extern int restaurer;
extern bool showlogo;
extern bool filtrer_all;
extern bool filtrer_groupe;
extern bool filtrer_persos;
extern bool filtre_actif;
extern QStrList filtre_perso;
extern QStrList my_alias;
extern QStrList existing_alias;
extern QString appdir;
extern QString hostname;

Options::Options(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();

/*lecture options*/
if (beeper) beep1->setChecked(true);
if (loguer) log1->setChecked(true);
if (restaurer == 0) icon1->setChecked(true);
else if (restaurer == 1) icon2->setChecked(true);
else icon3->setChecked(true);
if (showlogo) logo1->setChecked(true);
if (filtre_actif) {
	filtre->setChecked(true);
	slotFiltreClicked();
}
if (filtrer_all) filtre_all->setChecked(true);
if (filtrer_groupe) filtre_groupe->setChecked(true);
if (filtrer_persos) filtre_persos->setChecked(true);

filtres_de->clear();
filtres_de->insertStrList(&filtre_perso);

my_alias_temp = my_alias;
existing_alias_temp = existing_alias;
InitAlias();

	connect (alias_tree, SIGNAL(highlighted(int)),SLOT(alias_selected(int)));
	connect (Ok_Button,SIGNAL(clicked()),SLOT(slotOkClicked()));
	connect (Cancel_Button,SIGNAL(clicked()),SLOT(slotCancelClicked()));
	connect (icon1, SIGNAL(clicked()),SLOT(slotIcon1Clicked()));
	connect (icon2, SIGNAL(clicked()),SLOT(slotIcon2Clicked()));
	connect (icon3, SIGNAL(clicked()),SLOT(slotIcon3Clicked()));
	connect (filtre, SIGNAL(clicked()),SLOT(slotFiltreClicked()));
	connect (add, SIGNAL(clicked()),SLOT(slotAddClicked()));
	connect (del, SIGNAL(clicked()),SLOT(slotDelClicked()));
	connect (add2, SIGNAL(clicked()),SLOT(slotAdd2Clicked()));
	connect (del2, SIGNAL(clicked()),SLOT(slotDel2Clicked()));
}

Options::~Options(){
}

void Options::slotOkClicked(){
if (beep1->isChecked()) beeper = true;
else beeper = false;

if (icon1->isChecked()) restaurer = 0;
else if (icon2->isChecked()) restaurer = 1;
else restaurer = 2;

if (log1->isChecked()) loguer = true;
else loguer = false;

if (logo1->isChecked()) showlogo = true;
else showlogo = false;

if (filtre->isChecked()) filtre_actif = true;
else filtre_actif = false;
if (filtre_all->isChecked()) filtrer_all = true;
else filtrer_all = false;
if (filtre_groupe->isChecked()) filtrer_groupe = true;
else filtrer_groupe = false;
if (filtre_persos->isChecked()) filtrer_persos = true;
else filtrer_persos = false;

filtre_perso.clear();
unsigned int i;
for (i=0; i < filtres_de->count(); i++)
	filtre_perso.append(filtres_de->text(i));

my_alias = my_alias_temp;
existing_alias = existing_alias_temp;

this->accept();
}

void Options::slotCancelClicked(){
this->reject();
}

void Options::slotIcon1Clicked(){
icon2->setChecked(false);
icon3->setChecked(false);
icon1->setChecked(true);
}

void Options::slotIcon2Clicked(){
icon1->setChecked(false);
icon3->setChecked(false);
icon2->setChecked(true);
}

void Options::slotIcon3Clicked(){
icon1->setChecked(false);
icon2->setChecked(false);
icon3->setChecked(true);
}

void Options::slotFiltreClicked(){
if (filtre_all->isEnabled()){
filtre_all->setEnabled(false);
filtre_groupe->setEnabled(false);
filtre_persos->setEnabled(false);
filtres_de->setEnabled(false);
filtrer_de->setEnabled(false);
new_filtre->setEnabled(false);
add->setEnabled(false);
del->setEnabled(false);
}
else
{
filtre_all->setEnabled(true);
filtre_groupe->setEnabled(true);
filtre_persos->setEnabled(true);
filtres_de->setEnabled(true);
filtrer_de->setEnabled(true);
new_filtre->setEnabled(true);
add->setEnabled(true);
del->setEnabled(true);
}
}

void Options::slotAddClicked(){
QString t(new_filtre->text());
filtres_de->insertItem(t.upper());
new_filtre->clear();
}

void Options::slotDelClicked(){
filtres_de->removeItem(filtres_de->currentItem());
}

void Options::InitAlias(){
unsigned int i;
int idx=-1;
QString temp;
alias_tree->clear();
QPixmap mach(appdir + "/pics/machine.xpm");
QPixmap group(appdir + "/pics/group.xpm");
for (i=0 ; i <= existing_alias_temp.count(); i++){
temp = existing_alias_temp.at(i);
if (temp == temp.upper())
	{
	alias_tree->insertItem(temp, &group,-1);
	idx++;
	}
else
	{
	alias_tree->addChildItem(temp, &mach, idx);
	}
}
}

void Options::slotAdd2Clicked(){
QPixmap mach(appdir + "/pics/machine.xpm");
QPixmap group(appdir + "/pics/group.xpm");
QString s = new_alias->text();
s = s.upper();
QString my_name;
my_name = hostname.lower();

if ( existing_alias_temp.contains(s) != 0)
{
	if (my_alias_temp.contains(s) == 0)
		{
		int selected = 0;
		KTreeListItem *v = alias_tree->itemAt(0);
		QString t(v->getText());
	  while (t != s)
			{
			selected++;
			v = alias_tree->itemAt(selected);
			t = v->getText();
			}
		my_alias_temp.append(s);
		alias_tree->addChildItem(my_name, &mach, selected);
		int idx =	existing_alias_temp.find(s);
		existing_alias_temp.insert(idx+1, my_name);
		}
}
else
{
	alias_tree->insertItem(s, &group,-1);
	alias_tree->addChildItem(my_name, &mach,alias_tree->visibleCount()-1);
	my_alias_temp.append(s);
	existing_alias_temp.append(s);
	existing_alias_temp.append(my_name);
}
}

void Options::slotDel2Clicked(){
KTreeListItem *v = alias_tree->getCurrentItem();
QString t(v->getText());
QString nouveau(new_alias->text());
nouveau = nouveau.upper();
QString temp;

alias_selected (alias_tree->currentItem());

if (t.upper() == hostname)
	{
	int idx =	my_alias_temp.find(nouveau);
	my_alias_temp.remove(idx);

	idx =	existing_alias_temp.find(nouveau);
	int idx2 = existing_alias_temp.findNext(t);
	existing_alias_temp.remove(idx2);
	temp = existing_alias_temp.at(idx+1);
	if (temp == temp.upper() || temp.isEmpty()) existing_alias_temp.remove(idx);
	InitAlias();
	}
}

void Options::alias_selected(int idx){
KTreeListItem *v = alias_tree->itemAt(idx);
QString t(v->getText());
int selected = alias_tree->currentItem()+1;
while ( t != t.upper())
	{
	selected--;
	v = alias_tree->itemAt(selected);
	t = v->getText();
	}
new_alias->setText(t);
}
