/***************************************************************************
                          ktuxpop.h  -  description
                             -------------------
    begin                : lun avr 17 13:02:59 CEST 2000
    copyright            : (C) 2000 by Mickal Marchand
    email                : MikMak@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTUXPOP_H
#define KTUXPOP_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define DATA_PERM S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH


// include files for KDE 
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include "ctabctl.h"
#include <qwidget.h>
#include <qmultilinedit.h>
#include "reception.h"
#include <qlabel.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <qtimer.h>
#include <string.h>
#include <qstring.h>
#include <time.h>
#include <kled.h>
#include <qpixmap.h>
#include <qfile.h>
#include "options.h"
#include <qstrlist.h>
#include <qsocketnotifier.h>
#include "envoi_dialog.h"
#include <popups.h>
#include "repondeur.h"
#include <netdb.h>
#include "workgrp.h"
#include <pthread.h>
#include "people.h"
#include "firstinstall.h"

void samba_message(int argc,char *argv[]);
int lock_reg (int fd, int cmd, int type, off_t offset, int whence, off_t len);
QStrList Resolve(QString name,QString dest_ip);
QString make_nmb_name(const char *In);
void *scan_people(void *arg);
void *thread_alias(void *arg);
void normalperms(void);
void enhancedperms(void);

class KTuxPop : public KTMainWindow
{
  Q_OBJECT

  public:
    KTuxPop();
    ~KTuxPop();
    void enableCommand(int id_);
    void disableCommand(int id_);
	  void SetLogo();
	  void UnsetNew();
	  void UpdateLed();
	  void UnsetLogo();
	  bool CheckFiltre(QString m,QString o,QString d,int type);
	  QString make_header(int id);
  /** Adjusts the text to the size of the tab which prevents from having horizontal scrollbars on QMultiLineEdit */
  void ShowText(QString text, int Tab);
  void record_alias(QString alias, QString nom);
  void delete_alias (QString alias,QString nom);

  protected:
    void saveOptions();
    void readOptions();
    void initKeyAccel();
    void initMenuBar();
		void initTabs();
    void initToolBar();
    void initStatusBar();
	  void initSockets();
    virtual bool queryExit();

  public slots:
    void commandCallback(int id_);
    void slotFileNew();
    void slotFileQuit();
    void slotEditCopy();
    void slotStatusMsg();
	  void slotEditOptions();
	  void slotFileSuivant();
 		void slotFilePrecedent();
	  void slotFileDelete();
	  void slotFileReply();
	  void Checkpopup(int sock);
	  void tabselected(int id);
		void Checksmbpopup();
	  void slotShowIp();
	  void slotOptionBeep();
	  void CheckSalup(int sock);
	  void slotOptionFiltre();
	  void slotOptionReplyer();


  private:
    KConfig *config;
    KAccel *keyAccel;
    QPopupMenu *fileMenu;
    QPopupMenu *editMenu;
    QPopupMenu *viewMenu;
    QPopupMenu *helpMenu;
  	CTabCtl *maintab;
		QWidget *w1;
		QWidget *w2;
		QWidget *w3;
		QMultiLineEdit *prive;
		QMultiLineEdit *groupe;
		QMultiLineEdit *autres;
		Reception *recus;
		QLabel *fromlabel;
		QLabel *tolabel;
		QMultiLineEdit *to;
		QMultiLineEdit *sender;
		int socket_perso;
		int socket_broadcast;
		struct sockaddr_in sin_broadcast;
		struct sockaddr_in sin_perso;
		int t_broadcast;
		int t_perso;
		QTimer *timer;
		QString hostname2;
		QString perso1;
		QString perso2;
		QString perso3;
		QString perso4;
		QString grpe2;
		QString group1;
		QString group2;
		QString group3;
		QString group4;
		QString toutlemonde;
		QString touslesgens;
		QString all;
		QString allpopup;
		QString etoile;
		QString mess_precedent;
		QString orig_precedent;
		QString dest_precedent;
		QString status;
		KLed *Myled;
		QPixmap *Logo;
		Options *Options_dialog;
		envoi_dialog *send;
		Popups *popup;
		firstinstall *install;
	  int socket_salup_entree_broad;
	  int socket_salup_entree_perso;
		struct sockaddr_in sin_entree_broad;
		struct sockaddr_in sin_entree_perso;
		pthread_t scanner;
		pthread_t scan_alias;
		QSocketNotifier *s_alias;

private: // Private methods
  void showStartupConfig();
	void Popup_Alias_Received();
};

#endif // KTUXPOP_H