#include <kmessagebox.h>
#include <klocale.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <stdio.h>
#include "rogue/dun.h"
#include "kmsgbar.h"
#include "roguec.h"
#include "krogue.h"
#include "kdun.h"

unsigned short vdungeon[DROWS][DCOLS];

void turn_into_games()
{
  if (true_uid!=0) setuid(saved_uid);
}

void turn_into_user()
{
  if (true_uid!=0) setuid(true_uid);
}

const char *_i18n(const char *str)
{
  static QCString buf;
  buf=i18n(str).utf8();
  return (const char *)buf;
}

void clean_up(char *str)
{
  if (str!=NULL && str[0]!='\0')
    KMessageBox::sorry(NULL, i18n("Rogue"), loc->translate(str));
  kapp->quit();
  exit(1);
}

void killed_by(object *obj, short other)
{
  dun->killedBy(obj, other);
}

void redrawr(int row1, int col1, int row2, int col2)
{
  if (!msg->willQuit)
    dun->updatePixmap(row1, col1, row2, col2);
}

void redraw(int row, int col)
{
  if (!msg->willQuit)
    redrawr(row, col, row, col);
}

void message(char *str, int intr)
{
  if (intr) interrupted=1;
  msg->message(QString::fromUtf8(str));
}

void krogue_message(const char *str)
{
  KMessageBox::sorry(NULL, i18n("Rogue"), QString::fromUtf8(str));
}

void print_stats(int i)
{
  top->printStats(i);
}

void win()
{
  dun->win();
}

const char form_names[][20]=
{
  "",
  "object",
  "monster",
  "plural",
  "plural",
  "color",
  "potion",
  "scroll",
  "material",
  "wand",
  "armor",
  "ring",
  "gem",
  "descr"
};

void do_aan(char *dest, const char *src, int n)
{
  int i, ps=1;
  for (i=0; i<n-1; i++)
  {
    *(dest++)=*src;
    if (!*src) return;
    if (*src==' ' || *src=='\t' || *src=='\n')
    {
      if (ps==2)
      {
        if (is_vowel(*(src+1)))
	{
	  dest--;
	  *(dest++)='n';
	  *(dest++)=*src;
	  i++;
	}
      } else ps=1;
      src++;
      continue;
    }
    if (*src=='a' && ps==1)
    {
      src++;
      ps=2;
      continue;
    }
    src++;
    ps=0;
  }
  if (i>=n) i=n-1;
  dest[i]=0;
}

static char saved_chr;

char *format_str2(char *buf, const char *str, const char *sn, char chr, int argc, ...)
{
  char buf2[MSGLEN];
  QString cptr, qbuf;
  int argt[10], argv, i, cind, clen;
  QCString fmt=str;
  QString newstr, args[10];
  va_list valist;

  saved_chr=' ';
  va_start(valist, argc);
  for (i=0; i<argc; i++)
  {
    argt[i]=va_arg(valist, int);
    argv=va_arg(valist, int);
    if (argt[i]==SNUMBER || argt[i]==LNUMBER)
    {
      long l;
      if (argt[i]==LNUMBER) l=*va_arg(valist, long *);
        else l=*va_arg(valist, short *);
      if (l==1) argv=20;
      else
      {
        argv=l%100;
        if (argv>=20) argv%=10;
      }
      args[i]=QString::number(l);
    } else args[i]=QString::fromUtf8((va_arg(valist, char *)));
//    printf("argt=%d, argv=%d, args=%s\n", argt, argv, args[i]);
    if (argt[i]!=STRING && argt[i]!=DESCR)
    {
      snprintf(buf2, 160, "_form.%s.%s", sn, form_names[argt[i]]);
//      printf("formstr=%s\n", buf2);
      cptr=i18n(buf2);
      if (cptr[0]!='_' && cptr[argv]!=' ')
      {
        fmt+=cptr[argv].latin1();
//        printf("c=%04x\n", cptr[argv].unicode());
      }
    }
  }
  va_end(valist);
  if (chr!=' ') fmt+=chr;
//  printf("fmt='%s'\n", (const char *)fmt);
  cptr=i18n(fmt);
  cind=0; clen=cptr.length();
//  printf("tfmt=%s\n", (const char *)cptr.local8Bit());
  newstr=QString::null;
//  printf("new=%s\n", (const char *)newstr);
  while (cind<clen)
  {
    if (cptr[cind]!='$' || cptr[++cind]!='{')
    {
      newstr+=cptr[cind++];
//      printf("new=%s, cptr=%s\n", (const char *)newstr, cptr);
      continue;
    }
    i=cptr[++cind].latin1()-'0';
    if (i<0 || i>=argc) continue;
//    printf("transl_id: %d\n", i);
    qbuf=args[i];
    while (cptr[++cind]!='}')
    {
      if (argt[i]!=DESCR) qbuf+=cptr[cind];
        else saved_chr=cptr[cind].latin1();
    }
    cind++;
//    printf("transl: %s->%s\n", buf2, i18n(buf2));
    if (!qbuf.isEmpty())
      if (argt[i]!=STRING && argt[i]!=DESCR) newstr+=i18n(qbuf.latin1());
	else newstr+=qbuf;
//    printf("new=%s\n", (const char *)newstr);
  }
//  printf("str=%s\n", (const char *)newstr);
  if (loc->language()=="C" || (strcmp(i18n("_rules").latin1(), "aan")==0))
    do_aan(buf, (const char *)newstr.utf8(), MSGLEN);
    else qstrncpy(buf, (const char *)newstr.utf8(), MSGLEN);
//  printf("buf=%s, len=%d, lennew=%d\n", buf, strlen(buf), strlen((const char *)newstr));
  return buf;
}

char get_saved_chr()
{
  return saved_chr;
}

void clear(void)
{
  memset(vdungeon, 0, sizeof(vdungeon));
  dun->clear();
}
