
#include "main.h"

#include "highscore.h"

#include <qfile.h>
#include <qlist.h>
#include <qlineedit.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <malloc.h>

CHighscoreDialog::CHighscoreDialog(QWidget* parent,int ys) : 
  QDialog(parent,"Highscores",true)
{
	_yourScore = ys;

	setFixedSize(200,200);
	setCaption("Highscores");
	
	_list = new QList<CListElement>;
	_list->setAutoDelete(true);
	
	_yourResult = NULL;
	if (_yourScore) {
		_yourResult = new QLabel(this);
		_yourResult->move(10,10);
		_yourResult->setFixedWidth(180);
	}

	_listBox = new QListBox(this);
	_listBox->setGeometry(10,40,180,80);
	_listBox->setEnabled(false);
	
	_ok = new QPushButton("OK",this);
	_ok->move(50,150);
	_ok->setDefault(true);

	connect(_ok,SIGNAL(clicked()),this,SLOT(accept()));

}

void CHighscoreDialog::initializeDialog()
{
	char temp[40];
	char newEntry = readList();

	if (_yourScore) {
		if (newEntry != -1) {
			QString n = nameDialog();
			if (n != "") {
				_list->insert(newEntry,new CListElement(_yourScore,n));
				sprintf(temp,"%i %s",_yourScore,(const char*) n);
			} else 
				sprintf(temp,"%i - No Highscore entry",_yourScore);
		} else {
			sprintf(temp,"You are not in the Highscores.");
		}
		
		_yourResult->setText(temp);
	}

	QListIterator<CListElement> it(*_list);
	it.toFirst();
	while(it.current()) {
		char* s; s = (char*) malloc(30);
		memset(s,0,30);
 		sprintf(s,"%i  %s",it.current()->_score,(const char*) it.current()->_name);
		_listBox->insertItem(new QListBoxText(s));
		++it;
		free(s);
	}

}

CHighscoreDialog::~CHighscoreDialog()
{
	writeList();
	delete _ok;
	delete _listBox;
	if (_yourScore) delete _yourResult;
	delete _list;
}

QString CHighscoreDialog::nameDialog()
{
	QDialog dlg(NULL,"Your Name",true);
	dlg.setCaption("Your Name");
	dlg.setFixedSize(200,150);

	QLabel lab("Enter your name for highscore list",&dlg);
	lab.setGeometry(20,20,160,20);

	QLineEdit ed(&dlg);
	ed.setGeometry(20,50,160,ed.height());

	QPushButton ok(&dlg,"OK");
	ok.setGeometry(70,110,60,30);
	ok.setText("OK");
	ok.setDefault(true);

	ed.setFocus();

	connect(&ok,SIGNAL(clicked()),&dlg,SLOT(accept()));

	dlg.exec();

	return ed.text();
}

void CHighscoreDialog::getHighscoreFile(char* name)
{
	char t[50];
	strcpy(t,getenv("HOME"));	
	strcat(t,"/.kpuzzle-highscores");
	strcpy(name,t);
}

char CHighscoreDialog::readList()
{
	char name[21];
	char filename[50];
	
	int score;
	int readChars;
	char place = -1; // Place of player in highscores
	char counter = 0;

	getHighscoreFile(filename);
	FILE* f = fopen(filename,"r");

	if (!f) return 0;
	
	do {
		readChars = fscanf(f,"%i %s",&score,name);
		if (readChars != 2) break;
		
		char* spc;
		while ((spc = strchr(name,'\\')) != NULL) {
			*spc = ' ';
		}	

		_list->append(new CListElement(score,name));

		if (place == -1 && score < _yourScore) place = counter;

		counter++;
	} while (counter < MAX_HIGHSCORES - 1);  
	
	if (place == -1 && counter < MAX_HIGHSCORES - 1) place = counter;

	fclose(f);

	return place;
}

bool CHighscoreDialog::writeList()
{
	char filename[50];

	getHighscoreFile(filename);
	FILE* f = fopen(filename,"w");
	if (!f) return false;

	QListIterator<CListElement> it(*_list);
	for (it.toFirst();it.current();++it) {
		char name[21];
		strcpy(name,it.current()->_name);
		char* spc;
		while ((spc = strchr(name,' ')) != NULL) {
			*spc = '\\';
		}	

		fprintf(f,"%i %s\n",it.current()->_score,name);
 	}

	fclose(f);
	return true;
}
