/***************************************************************************
                          astar.cpp  -  description
                             -------------------
    begin                : Wed Nov 14 2001
    copyright            : (C) 2001 by Jos Pablo Fernndez
    email                : jpablo@di.uc3m.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlist.h>

#include <iostream.h>

#include "astar.h"
#include "tree.h"
#include "astardata.h"

#include "milist.h"

AStar::AStar(){
	the_best = 0 ;
	min_h = 32000 ;
}

AStar::~AStar(){
	/* delete data ; */
	delete tree ;
}

/** No descriptions */
void AStar::init(AStarData *data) {
	/* No funciona, no llama al constructor de PeggyData */
	/* AStar::data = new AStarData(*data) ; */
	AStar::data = data ;

	sucess = false ;
	tot_process = 0 ;
	the_best = null ;
	tree = new Tree<AStarData>(AStar::data) ;
	A.prepend(tree) ;
}

/** No descriptions */
bool AStar::resolve(int process) {
	
	Tree<AStarData> *sucesors ;
	Tree<AStarData> *aux ;
	AStarData *N ;
	int count_process = 0 ;
	Tree<AStarData> *ins ;

	/* DEBUG cout << "================" << endl ; */
	/* DEBUG cout << "num elem: " << A.count() << endl ;	*/
	
	while (!A.isEmpty() && !sucess && count_process < process) {
		aux = A.take(0) ;

		N = aux->data();

		count_process++ ;
				
		if (N->isGoal()) {
			sucess = true ;
			/* DEBUG cout << "exito" << endl ; */
		}

		/* BUG : ??? con < puede coincidir con el nodo raiz */
		if (N->get_h() <= min_h) {
			min_h = N->get_h() ;
			the_best = aux ;
		}

		sucesors = N->sucesors() ;
		aux->insertSons(sucesors) ;
		
		for (ins = sucesors; ins != null; ins = ins->brother() ) {
					A.inSort(ins) ;
		}
		/* DEBUG
		cout << "Num elem: " << A.count() << endl ;
		cout << "Tratados: " << tratados << endl ;
		cout << "-----------------------------------------------" << endl ;
		*/
	}

	for (aux = the_best; aux != null; aux = aux->parent() ) {
		if (aux->parent() != null)
			solution.prepend(aux) ;
	}

	/* cout << "A.count: " << A.count() << endl ;   */      /* DEBUG */
	if (sucess || A.isEmpty() )
		return true ;
	return false ;	
}


Tree<AStarData> *AStar::best() {

	/* BUG 7/3/2002 : Ponia A.isEmpty(), esto pasa cuando hemos estudiado todas las posibilidades,
	con o sin solucion  */
	if (solution.isEmpty())
		return null ;
	return ( solution.take(0) ) ;
 }
