/***************************************************************************
                          kcmapfile.cpp
                      -------------------
    description          :
    begin                : Mon Jan 1 2001
    copyright            : (C) 2001 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kcmapfile.h"

KCMapFile::KCMapFile()
{
  setDollarExpansion(false);
}

KCMapFile::KCMapFile(QString filename):KConfig(filename)
{
  setDollarExpansion(false);
}

KCMapFile::~KCMapFile()
{
}

void KCMapFile::readFile(QFile& file)
{
  parseOneConfigFile(file);
}

void KCMapFile::writeFile(QFile& file)
{
  writeConfigFile(file);
}

void KCMapFile::setRoomGroup(int rnum)
{
  setGroup(numberedGroup("ROOM-", rnum));
}

void KCMapFile::setPathGroup(int pnum)
{
  setGroup(numberedGroup("PATH-", pnum));
}

void KCMapFile::setTextGroup(int tnum)
{
  setGroup(numberedGroup("TEXT-", tnum));
}

void KCMapFile::setLevelGroup(int lnum)
{
  setGroup(numberedGroup("LEVEL-", lnum));
}

void KCMapFile::setZoneGroup(int znum)
{
  setGroup(numberedGroup("ZONE-", znum));
}

void KCMapFile::setSpeedwalkGroup(int snum)
{
  setGroup(numberedGroup("SPEEDWALK-", snum));
}

QString KCMapFile::numberedGroup(QString groupPrefix, int number)
{
  QString numString;
  numString.setNum(number);
  groupPrefix.append(numString);

  return groupPrefix;
}

void KCMapFile::writeVersion(int major, int minor)
{
  const char* lastGroup = group();
  setGroup("VERSION");
  writeEntry("major", major);
  writeEntry("minor", minor);
  setGroup(lastGroup);
}

void KCMapFile::readVersion(int &major, int &minor)
{
  const char* lastGroup = group();
  setGroup("VERSION");
  major = readNumEntry("major", 0);
  minor = readNumEntry("minor", 0);
  setGroup(lastGroup);
}

void KCMapFile::writeCount(QString name, int number)
{
  const char* lastGroup = group();
  setGroup("COUNTS");
  writeEntry(name, number);
  setGroup(lastGroup);
}

int KCMapFile::readCount(QString name)
{
  int result;
  const char* lastGroup = group();
  setGroup("COUNTS");
  result = readNumEntry(name, 0);
  setGroup(lastGroup);

  return result;
}


