/***************************************************************************
                          dlgprofiletriggers.cpp
                      -------------------
    description          :
    begin                : Tue Nov 2 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgprofiletriggers.h"
#include <qmessagebox.h>

DlgProfileTriggers::DlgProfileTriggers(KmudDoc* document, QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Triggers"));

	profile = document->getCharacterProfile(document->getCurrentCharacterID());
	profile->readTriggers();
	
	initDialog();
	
	triggerProfile_Label->setText(document->getCurrentCharacterID());

	connect( cancel_Button, SIGNAL(clicked()), SLOT(slotCancelPressed()) );
	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	connect( new_Button, SIGNAL(clicked()), SLOT(slotNewPressed()) );
	connect( delete_Button, SIGNAL(clicked()), SLOT(slotDeletePressed()) );
	connect( edit_Button, SIGNAL(clicked()), SLOT(slotEditPressed()) );
	connect( triggers_ListBox, SIGNAL(highlighted(int)), SLOT(slotShowItem(int)) );
	
	if (profile == NULL ) {
		triggers_ListBox->clear();
		triggers_ListBox->insertItem("NO ACTIVE PROFILE", 0);
		return;
	}
	updateListView();
	
	if (triggers_ListBox->text(0) != NULL)
		triggers_ListBox->setSelected(0, true);
}

DlgProfileTriggers::~DlgProfileTriggers(){
}

/** Updates the List View of all the triggers */
void DlgProfileTriggers::updateListView() {
	TriggerEntry* trigger;

	triggers_ListBox->clear();

	trigger = profile->firstTrigger();

	while (trigger != NULL) {
		triggers_ListBox->insertItem(trigger->name, 0);
		trigger = profile->nextTrigger();
	}
}

/**                 **
 **    S L O T S    **
 **                 **/

/** When "OK" is pressed */
void DlgProfileTriggers::slotOKPressed(){
	profile->writeTriggers();
	accept();
}

/** When "CANCEL" is pressed */
void DlgProfileTriggers::slotCancelPressed(){
	reject();
}

/** When "NEW" is pressed */
void DlgProfileTriggers::slotNewPressed(){
	DlgProfileTriggersInput d(this,"New trigger");

	if(d.exec()) {
		if ((d.getTrigger () == "") || ((d.getType()==0) && (d.getCommand () == "")) )
		{
			QMessageBox::information(this, i18n("Warning"), i18n("The triggerinformation is empty. No trigger added."));
			return;
		} // if
		profile->insertTrigger (d.getTrigger(), d.getIsRegEx(), d.getType(), d.getCommand(), d.getSetFgColor(), d.getFgColor(), d.getSetBgColor(), d.getBgColor(), d.getSetFont(), d.getFont());
	} // if
	updateListView ();
	if (triggers_ListBox->text (0) != NULL) 
		triggers_ListBox->setSelected (0, true);
}

/** When "DELETE" is pressed */
void DlgProfileTriggers::slotDeletePressed(){
	uint i = 0;

	while (i< triggers_ListBox->count()) {
		if (triggers_ListBox->isSelected(i))
		{
			profile->removeTrigger(QString(triggers_ListBox->text(i)));
		}
		i++;
	}
	updateListView();

	if (triggers_ListBox->text(0) != NULL)
		triggers_ListBox->setSelected(0, true);
}

/** When Edit is pressed */
void DlgProfileTriggers::slotEditPressed(){
	DlgProfileTriggersInput d (this, "Edit Trigger");
	if (triggers_ListBox->currentItem () == -1)
	{
		QMessageBox::information(this, i18n("Warning"), i18n("No trigger selected. Please select the trigger you want to change!"));
		return;
	} // if
	TriggerEntry* te = profile->getTrigger (triggers_ListBox->text (triggers_ListBox->currentItem ()));
	d.setTrigger(te->name);
	d.setIsRegEx(te->isRegEx);
	d.setCommand(te->command);
	d.setType(te->type);
	d.setSetFgColor(te->setFgc);
	d.setFgColor(te->fgc);
	d.setSetBgColor(te->setBgc);
	d.setBgColor(te->bgc);
	d.setSetFont(te->setFont);
	d.setFont(te->font);

	if (d.exec ())
	{
		if ((d.getTrigger () == "") || ((d.getType()==0) && (d.getCommand () == "")) )
		{
			QMessageBox::information(this, i18n("Warning"), i18n("The triggerinformation is empty. No trigger added."));
			return;
		} // if
		te->name = d.getTrigger();
		te->isRegEx = d.getIsRegEx();
		te->type = d.getType();
		te->command = d.getCommand();
		te->setFgc = d.getSetFgColor();
		te->fgc = d.getFgColor();
		te->setBgc = d.getSetBgColor();
		te->bgc = d.getBgColor();
		te->setFont = d.getSetFont();
		te->font = d.getFont();
		// profile->insertTrigger (d.getTrigger (), d.getDefinition ());
	} // if
	updateListView ();
	if (triggers_ListBox->text (0) != NULL)
		triggers_ListBox->setSelected (0, true);
    /*TriggerEntry* trig;
    QString n, d;
    uint i = 0;
    int current = 0;*/

/*	DlgProfileTriggersInput diag(this,"Edit trigger");

	if(diag.exec()) {
	}*/

/*    n = triggerName_LineEdit->text();
    d = triggerDefinition_LineEdit->text();

    trig = NULL;
    while (i < triggers_ListBox->count()) {
        if (triggers_ListBox->isSelected(i)) {
            trig = profile->getTrigger(QString(triggers_ListBox->text(i)));
        }
        i++;
    }

    if (trig == NULL) return;  // nothing was selected

    trig->name = n;
    trig->definition = d;
    current = triggers_ListBox->currentItem();

    triggers_ListBox->removeItem(current);
    triggers_ListBox->insertItem(n, current);

    triggers_ListBox->setSelected(current, true);
*/
}

void DlgProfileTriggers::slotShowItem(int i){
	TriggerEntry* trigger;
	QString name = QString(triggers_ListBox->text(i));

//    n = QString(triggers_ListBox->text(triggers_ListBox->currentItem()));
	trigger = profile->getTrigger(name);

/*    if (name != NULL)
    {
        triggerName_LineEdit->setText(name);
        triggerDefinition_LineEdit->setText(trigger->definition);
    }
*/
}
