/***************************************************************************
                          cmudlineedit.h
                       -------------------
    description          : Class implementing an input line
    begin                : Wed Sep 8 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMUDLINEEDIT_H
#define CMUDLINEEDIT_H


#include <qlineedit.h>
#include <qkeycode.h>
#include <qstrlist.h>
#include <qpopupmenu.h>

#include "kmuddoc.h"

/**
  * Class implementing an input line. Supports history and the feature to keep the last input
  * selected rather than deleting it.
  *@author Stephan Uhlmann
  */

class CMudLineEdit : public QLineEdit  {
	Q_OBJECT
public:
	/** constructor */
	CMudLineEdit(KmudDoc* doc, QWidget * parent=0, const char * name=0);
	/** destructor */
	~CMudLineEdit();

	/** sets the maximum number of lines kept in the history  */
	void setMaxHistoryLines(int);
	/** returns true if the option for keeping the last input is set */
	bool getKeepLastInput();
	/** set/unsets the behaviour to keep the last input selected rather than deleting it */
	void setKeepLastInput(bool);
	/** returns true if the option for selecting the text in the input on getting focus is set */
	bool getSelectAllOnFocus();
	/** set/unsets the behaviour to select all text in the input if the lineedit gets focus */
	void setSelectAllOnFocus(bool);
	/** gets the maximum number of lines kept in history */
	int getMaxHistoryLines();
	/** sets the current position in the history */
	void setHistoryPosition(int);
	/** gets the current position in the history. */
	int getHistoryPosition();
	/** sets the to complete input for use with history completion */
	int setCompletionInput(QString);
	/** gets the to complete input */
	QString getCompletionInput();
	/** Scrolls in the history according to the pressed key. */
	void historyScroll(QKeyEvent * e);
	void addInputToHistory(QString);

	void setHistory(QStrList* h);
	QStrList* getHistory();

protected:
	/** redefeined to display history menu when the right button is pressed */
	void mouseReleaseEvent(QMouseEvent *e);
	/** redefined keyPressevent to get special keys */
	void keyPressEvent(QKeyEvent*);
	/** select full text on focus in */
	void focusInEvent(QFocusEvent*);
	/** moves the history in the input line one item up */
	void historyUp();
	/** moves the history in the input line one item down */
	void historyDown();
	/** removes the QT-Selection-Bug */
	virtual void focusOutEvent(QFocusEvent* event);
	
protected slots:
	/** Called when a item in the history menu is selected */
	void slotHistoryMenuSelected(int item);

private:
	QPopupMenu history_menu;
	QStrList* history;
	QString completionInput;
	int historyPosition;
	int maxHistoryLines;
	bool keepLastInput;
	bool selectAllOnFocus;

	KmudDoc* document;
    	
signals:
	/** emitted when pageup is pressed */
	void scrollKeyPressed(QKeyEvent*);
	/** emitted when a macro is pressed */
	void macroPressed(QString);
signals:
	/** send the text in the Inputline */
	void textSend (QString s);
};

#endif