/***************************************************************************
                          cmaptext.h
                      -------------------
    description          : Map text element
    begin                : Wed Oct 20 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMAPTEXT_H
#define CMAPTEXT_H

#include <qpainter.h>

#include "cmapelement.h"
#include "cmapzone.h"

class CMapZone;

/** This class is used to repesent text map elements
  * and store the data associated with a text map element.
  * @author John-Paul Stanford */
class CMapText : public CMapElement
{
public:
	/** The constructor for text elements
	  * @param str The text displayed by the text element
	  * @param x The x position of the text on the map
	  * @param y The y position of the text on the map
	  * @param font The font used to display the text
	  */
	CMapText (QString str,int x,int y,QFont font,CMapZone *mapZone);

	/** The destrutor for text elements */
	~CMapText();
	
	void setEditMode(bool edit);
	/** Over ridden CMapElement::getElementType to return the type TEXT
	  * @return The element type of the element
	  */	
	virtual elementTyp getElementType(void);
	/** Sets the text of the text element
	  * @param str The new string that the text element should be set to
	  */
	void setText(QString str);
	/** Gets the text of the text element
	  * @return The text
	  */
	QString getText(void);
	/** Used to tell the text element which level it is on
	  * @param level The level number
	  */
	void setLevel(int level);
	/** Used to find out which level the text element is on
	  * @return The level number
	  */
	int getLevel(void);
	/** Used to set the font of the text. This font is used when drawing the text.
	  * @param f The required font of the text
	  */
	void setFont(QFont f);
	/** This menthod will return the font used to display the text
	  * @return The font used to display text
	  */
	QFont getFont(void);
	/** This is used to return the colour of the text
	  * @return The colour of the text
	  */
	QColor getColour(void);
	/** This method is used to set the colour of the text
	  * @param colour The colour to set the text to
	  */
	void setColour(QColor colour);
	/** This method is over ridden from CMapElement::paint. It is used
	  * draw the text on the map.
	  * @param p A pointer to the paint device the text is to be drawn on
	  * @param currentZone The current zone	
	  */	
	virtual void paint(QPainter *p,CMapZone *currentZone);
	/** This method is over ridden from CMapElement::dragPaint. It is used
	  * draw the text on the map at a given offset.
	  * @param p A pointer to the paint device the text is to be drawn on
	  * @param offsetx The x offset of from the text's posotion where the text is to be drawn
	  * @param offsetx The y offset of from the text's posotion where the text is to be drawn	
	  * @param currentZone The current zone	
	  */	
	virtual void dragPaint(QPainter *p,int offsetx,int offsety,CMapZone *currentZone);
	/** This method is over ridden from CMapElement::lowerpaint. It is used
	  * draw the text on the map as a lower level.
	  * @param p A pointer to the paint device the text is to be drawn on
	  * @param currentZone The current zone	
	  */		
	virtual void lowerPaint(QPainter *p,CMapZone *currentZone);
	/** This method is over ridden from CMapElement::higherpaint. It is used
	  * draw the text on the map as a higher level.
	  * @param p A pointer to the paint device the text is to be drawn on
	  * @param currentZone The current zone
	  */			
	virtual void higherPaint(QPainter *p,CMapZone *currentZone);
	/** This is used to create  a new copy of the text element and return
	  * a pointer to the new text element
	  * @return A pointer to the copy of the text element.
	  */
	virtual CMapElement *copy(void);

	/** Set the zone that the text element belongs to
	  * @param mapZone The zone
	  */
	void setZone(CMapZone *mapZone);
	/** Get the zone that the text element belongs to
	  * @return the zone
	  */
	CMapZone *getZone(void);
	
	virtual void read(KCMapFile* kcmfile);
	virtual void write(KCMapFile* kcmfile);
	
private:
	CMapZone *zone;
	QColor col;
	QString text;
	QFont font;
	int lvl;
};

#endif