/***************************************************************************
                          ccharacterprofile.cpp
                           -------------------
    description          : Character Profile Class
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ccharacterprofile.h"


CCharacterProfile::CCharacterProfile(){
	filename="";
	loggingEnabled=false;
	logFilename="";
}

CCharacterProfile::~CCharacterProfile(){
}

QString CCharacterProfile::getFileName()
{
	return filename;
}

void CCharacterProfile::setFileName(QString f)
{
	filename=f;
}

void CCharacterProfile::readData()
{
	KSimpleConfig mudconf(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);

	mudconf.setGroup("Logging");
	loggingEnabled = mudconf.readBoolEntry("LoggingEnabled",false);
	logANSIEnabled = mudconf.readBoolEntry("LogANSIEnabled",false);
	logFilename = mudconf.readEntry("LogFilename","");
	
	mudconf.setGroup("Mapper");
	map_start_x = mudconf.readNumEntry("StartX",-2);
	map_start_y = mudconf.readNumEntry("StartY",-2);	
	map_start_level = mudconf.readNumEntry("StartLevel",0);
	map_start_zone = mudconf.readNumEntry("StartZone",0);

	readAliases();
	readTriggers();
	readToolbar();
}

void CCharacterProfile::readAliases()
{
	AliasEntry* alias;
	QString groupname, n, d, m, tmp;
	QString mod;
	KSimpleConfig aliasdb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	KGroupIterator *gi;
	uint i = 0;

	aliases.setAutoDelete(true);
	aliases.clear();
	
	aliasdb.setDollarExpansion(false);

	gi = aliasdb.groupIterator();
	gi->toFirst();

	while (gi->current())
	{
		groupname = gi->currentKey();

		if (groupname == "Aliases")
		{
			QString name = "";
			aliasdb.setGroup("Aliases");

			while (name != NULL) {
				n.setNum(i).append("Name");
				d.setNum(i).append("Def");
				m.setNum(i).append("Macro");
				mod.setNum(i).append("Modifiers");

				tmp = aliasdb.readEntry(n, "");
				if (tmp == "")
					break;
				alias = new AliasEntry;
				alias->name = tmp;
				alias->definition = aliasdb.readEntry(d, "");
				alias->macro = aliasdb.readNumEntry(m, 0);
				alias->modifiers = (ButtonState) aliasdb.readUnsignedNumEntry(mod, 0);
				aliases.append(alias);
				i++;
			}
		}
		++(*gi);
	}
	delete gi;
}

void CCharacterProfile::readTriggers()
{
	KSimpleConfig triggerdb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	QString groupname, n, ire, t, d, sfg, fg, sbg, bg, sfnt, fnt, name;
	QColor aColor;
	QFont aFont;
	TriggerEntry* trigger;
	KGroupIterator *gi;
	uint i = 0;

	triggers.setAutoDelete(true);
	triggers.clear();

	triggerdb.setDollarExpansion(false);
	
	gi = triggerdb.groupIterator();
	gi->toFirst();

	while (gi->current())
	{
		groupname=gi->currentKey();
		if (groupname == "Triggers")
		{
			name = "";
			triggerdb.setGroup("Triggers");

			while (name != NULL) {
				n.setNum(i).append("Name");
				ire.setNum(i).append("RegEx");
				t.setNum(i).append("Type");
				d.setNum(i).append("Def");
				sfg.setNum(i).append("SetForeground");
				fg.setNum(i).append("Foreground");
				sbg.setNum(i).append("Setbackground");
				bg.setNum(i).append("Background");
				sfnt.setNum(i).append("SetFont");
				fnt.setNum(i).append("Font");
				name = triggerdb.readEntry(n, NULL);
				if (name == NULL)
					break;
				trigger = new TriggerEntry;
				trigger->name = name;
				trigger->isRegEx = triggerdb.readBoolEntry(ire, false);
				trigger->type = triggerdb.readNumEntry(t, 0);
				trigger->command = triggerdb.readEntry(d, "");
				trigger->setFgc = triggerdb.readBoolEntry(sfg, false);
				aColor=QColor(0,255,0);
				trigger->fgc = triggerdb.readColorEntry(fg, &aColor);
				trigger->setBgc = triggerdb.readBoolEntry(sbg, false);
				aColor=QColor(0,0,0);
				trigger->bgc = triggerdb.readColorEntry(bg, &aColor);
				trigger->setFont = triggerdb.readBoolEntry(sfnt, false);
				aFont=QFont("fixed");
				trigger->font = triggerdb.readFontEntry(fnt, &aFont);

				triggers.append(trigger);
				i++;
			}
		}
		++(*gi);
	}
	delete gi;
}

void CCharacterProfile::readToolbar()
{
	KSimpleConfig toolbardb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	QString groupname, n, c,ic, name;
	ToolbarEntry* toolbarEntry;
	KGroupIterator *gi;
	uint i = 0;

	toolbar.setAutoDelete(true);
	toolbar.clear();

	gi = toolbardb.groupIterator();
	gi->toFirst();

	while (gi->current())
	{
		groupname=gi->currentKey();
		if (groupname == "Toolbar")
		{
			name = "";
			toolbardb.setGroup("Toolbar");

			while (name != NULL) {
				n.setNum(i).append("Name");
				c.setNum(i).append("Command");
				ic.setNum(i).append("Icon");				
				name = toolbardb.readEntry(n, NULL);
				if (name == NULL)
					break;
				toolbarEntry = new ToolbarEntry;
				toolbarEntry->name = name;
				toolbarEntry->command = toolbardb.readEntry(c, "");
				toolbarEntry->icon = toolbardb.readEntry(ic, "");
				toolbar.append(toolbarEntry);
				i++;
			}
		}
		++(*gi);
	}
	delete gi;
}

void CCharacterProfile::writeData()
{
	KSimpleConfig mudconf(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);

	mudconf.setGroup("Logging");
	mudconf.writeEntry("LoggingEnabled",loggingEnabled);
	mudconf.writeEntry("LogANSIEnabled",logANSIEnabled);
	mudconf.writeEntry("LogFilename",logFilename);
	mudconf.setGroup("Mapper");
	mudconf.writeEntry("StartX",map_start_x);
	mudconf.writeEntry("StartY",map_start_y);
	mudconf.writeEntry("StartLevel",map_start_level);
	mudconf.writeEntry("StartZone",map_start_zone);	

	writeAliases();
	writeTriggers();
	writeToolbar();
}

void CCharacterProfile::writeToolbar()
{
	KSimpleConfig toolbardb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	QString n, c, ic;
	uint i;


	toolbardb.deleteGroup("Toolbar");
	toolbardb.sync();

	// Write the aliases
	toolbardb.setGroup("Toolbar");
	for (i = 0; i < toolbar.count(); i++) {
		n.setNum(i).append("Name");
		c.setNum(i).append("Command");
		ic.setNum(i).append("Icon");
		toolbardb.writeEntry(n, toolbar.at(i)->name);
		toolbardb.writeEntry(c, toolbar.at(i)->command);
		toolbardb.writeEntry(ic, toolbar.at(i)->icon);

	}
	toolbardb.sync();
}

void CCharacterProfile::writeAliases()
{
	KSimpleConfig aliasdb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	QString n, d, m;
	QString mod;
	uint i;


	aliasdb.deleteGroup("Aliases");
	aliasdb.sync();

	// Write the aliases
	aliasdb.setGroup("Aliases");
	for (i = 0; i < aliases.count(); i++) {
		n.setNum(i).append("Name");
		d.setNum(i).append("Def");
		m.setNum(i).append("Macro");
		mod.setNum(i).append("Modifiers");
		aliasdb.writeEntry(n, aliases.at(i)->name);
		aliasdb.writeEntry(d, aliases.at(i)->definition);
		aliasdb.writeEntry(m, aliases.at(i)->macro);
		aliasdb.writeEntry(mod, (uint) aliases.at(i)->modifiers);		
	}
	aliasdb.sync();
}

void CCharacterProfile::writeTriggers()
{

	KSimpleConfig triggerdb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	QString groupname, n, ire, t, d, sfg, fg, sbg, bg, sfnt, fnt;
	uint i;

	triggerdb.deleteGroup("Triggers");
	triggerdb.sync();


	// Write the triggers
	triggerdb.setGroup("Triggers");
	for (i = 0; i < triggers.count(); i++) {
		n.setNum(i).append("Name");
		ire.setNum(i).append("RegEx");
		t.setNum(i).append("Type");
		d.setNum(i).append("Def");
		sfg.setNum(i).append("SetForeground");
		fg.setNum(i).append("Foreground");
		sbg.setNum(i).append("SetBackground");
		bg.setNum(i).append("Background");
		sfnt.setNum(i).append("SetFont");
		fnt.setNum(i).append("Font");

		triggerdb.writeEntry(n, triggers.at(i)->name);
		triggerdb.writeEntry(ire, triggers.at(i)->isRegEx);
		triggerdb.writeEntry(t, triggers.at(i)->type);
		triggerdb.writeEntry(d, triggers.at(i)->command);
		triggerdb.writeEntry(sfg, triggers.at(i)->setFgc);
		triggerdb.writeEntry(fg, triggers.at(i)->fgc);
		triggerdb.writeEntry(sbg, triggers.at(i)->setBgc);
		triggerdb.writeEntry(bg, triggers.at(i)->bgc);
		triggerdb.writeEntry(sfnt, triggers.at(i)->setFont);
		triggerdb.writeEntry(fnt, triggers.at(i)->font);
	}
	triggerdb.sync();
}

void CCharacterProfile::insertAlias(QString name, QString def, int mac, ButtonState modifiers) {
	AliasEntry* alias;

	alias = new AliasEntry;
	alias->name = name;
	alias->definition = def;
	alias->macro = mac;
	alias->modifiers = modifiers;

	aliases.append(alias);
}

void CCharacterProfile::insertToolbarEntry(QString name,QString command , QString icon)
{
	ToolbarEntry *entry;
	
	entry = new ToolbarEntry;
	entry->name = name;
	entry->command = command;
	entry->icon = icon;
	
	toolbar.append(entry);
}

void CCharacterProfile::insertTrigger(QString name, bool isRegEx, int type, QString command, bool setFgc, QColor fgc, bool setBgc, QColor bgc, bool setFont, QFont font) {
	TriggerEntry* trigger;

	trigger = new TriggerEntry;
	trigger->name = name;
	trigger->isRegEx = isRegEx;
	trigger->type = type;
	trigger->command = command;
	trigger->setFgc = setFgc;
	trigger->fgc = fgc;
	trigger->setBgc = setBgc;
	trigger->bgc = bgc;
	trigger->setFont = setFont;
	trigger->font = font;

	triggers.append(trigger);
}

void CCharacterProfile::removeAlias(QString name) {
	AliasEntry* alias;

	alias = aliases.first();
	while (alias != NULL)
	{
		if (alias->name == name)
			aliases.remove(alias);
		alias = aliases.next();
	}
}

void CCharacterProfile::removeTrigger(QString name) {
	TriggerEntry* trigger;

	trigger = triggers.first();
	while (trigger != NULL)
	{
		if (trigger->name == name)
			triggers.remove(trigger);
		trigger = triggers.next();
	}
}

void CCharacterProfile::removeToolbarEntry(QString name) {
	ToolbarEntry* entry;

	entry = toolbar.first();
	while (entry != NULL)
	{
		if (entry->name == name)
			toolbar.remove(entry);
		entry = toolbar.next();
	}
}


AliasEntry* CCharacterProfile::getAlias(QString name)
{
	AliasEntry* alias;

	alias = firstAlias();
	while ((alias != NULL)&&(alias->name!=name))
		alias = nextAlias();
	return alias;
}

TriggerEntry* CCharacterProfile::getTrigger(QString name)
{
	TriggerEntry* trigger;

	trigger = firstTrigger();
	while ((trigger != NULL)&&(trigger->name!=name))
		trigger = nextTrigger();
	return trigger;
}

ToolbarEntry* CCharacterProfile::getToolbarEntryAt(int pos)
{
	ToolbarEntry* entry = toolbar.at(pos) ;
	
	return entry;

}

ToolbarEntry* CCharacterProfile::getToolbarEntry(QString name)
{
	ToolbarEntry* entry;

	entry = firstToolbarEntry();
	while ((entry != NULL)&&(entry->name!=name))
		entry = nextToolbarEntry();
	return entry;
}


ToolbarEntry* CCharacterProfile::firstToolbarEntry() {
	currentToolbarIndex = 0;
	if (toolbar.count() > 0)
		return toolbar.at(0);
	return NULL;
}

ToolbarEntry* CCharacterProfile::lastToolbarEntry() {
	currentToolbarIndex = toolbar.count()-1;
	return toolbar.last();
}

ToolbarEntry* CCharacterProfile::nextToolbarEntry() {
	currentToolbarIndex++;
	if (toolbar.count() > (unsigned int)currentToolbarIndex)
		return toolbar.at(currentToolbarIndex);
	return NULL;
}

ToolbarEntry* CCharacterProfile::previousToolbarEntry() {
	currentToolbarIndex--;
	if (currentToolbarIndex>=0)
		return toolbar.at(currentToolbarIndex);
	return NULL;
}

ToolbarEntry* CCharacterProfile::currentToolbarEntry() {
	if (toolbar.count() > (unsigned int)currentToolbarIndex)
		return toolbar.at(currentToolbarIndex);
	return NULL;
}

AliasEntry* CCharacterProfile::firstAlias() {
	currentAliasIndex = 0;
	if (aliases.count() > 0)
		return aliases.at(0);
	return NULL;
}

AliasEntry* CCharacterProfile::nextAlias() {
	currentAliasIndex++;
	if (aliases.count() > (unsigned int)currentAliasIndex)
		return aliases.at(currentAliasIndex);
	return NULL;
}

AliasEntry* CCharacterProfile::currentAlias() {
	if (aliases.count() > (unsigned int)currentAliasIndex)
		return aliases.at(currentAliasIndex);
	return NULL;
}


TriggerEntry* CCharacterProfile::firstTrigger() {
	currentTriggerIndex = 0;
	if (triggers.count() > 0)
		return triggers.at(0);
	return NULL;
}

TriggerEntry* CCharacterProfile::nextTrigger() {
	currentTriggerIndex++;
	if (triggers.count() > (unsigned int)currentTriggerIndex) 
		return triggers.at(currentTriggerIndex);
	return NULL;
}

TriggerEntry* CCharacterProfile::currentTrigger() {
	if (triggers.count() > (unsigned int)currentTriggerIndex) 
	   	return triggers.at(currentTriggerIndex);
	return NULL;
}

bool CCharacterProfile::getLoggingEnabled()
{
	return loggingEnabled;
}

void CCharacterProfile::setLoggingEnabled(bool b)
{
	loggingEnabled=b;
}


bool CCharacterProfile::getLogANSIEnabled()
{
	return logANSIEnabled;
}

void CCharacterProfile::setLogANSIEnabled(bool b)
{
	logANSIEnabled=b;
}


QString CCharacterProfile::getLogFilename()
{
	return logFilename;
}

void CCharacterProfile::setLogFilename(QString filename)
{
	logFilename=filename;
}




void CCharacterProfile::setMapStartX(signed int startx)
{ map_start_x = startx; }

void CCharacterProfile::setMapStartY(signed int starty)
{ map_start_y = starty;  }

void CCharacterProfile::setMapStartLevel(signed int start_level)
{ map_start_level = start_level; }

void CCharacterProfile::setMapStartZone(int start_zone)
{ map_start_zone = start_zone; }
	
signed int CCharacterProfile::getMapStartX(void)
{ return map_start_x; }

signed int CCharacterProfile::getMapStartY(void)
{ return map_start_y; }

signed int CCharacterProfile::getMapStartLevel(void)
{ return map_start_level; }

int CCharacterProfile::getMapStartZone(void)
{ return map_start_zone; }