// -*- Mode: C++; -*-
#ifndef CSetupDlg_included
#define CSetupDlg_included

#include "setupdlgdata.h"

class fontsetup;
class timersetup;

class CSetupDlg : public CSetupDlgData
{
    Q_OBJECT
public:
    CSetupDlg(QWidget* parent = NULL,const char* name = NULL);
    virtual ~CSetupDlg();
    const QFont&fixed_font()const;
    const QFont&nonprop_font()const;
    int StatusPolltime()const;
    int ThreadPolltime()const;
    virtual int exec();

protected:
    fontsetup*m_FontSetup;
    timersetup*m_TimerSetup;
    QFont m_FixedFont;
    QFont m_NonPropFont;
    int m_ThreadTime;
    int m_StatusTime;

protected slots: // Protected slots
    virtual void nonpropFontChanged(QFont&);
    virtual void fixFontChanged(QFont&);
    virtual void accept();
    virtual void threadTime(int);
    virtual void statusTime(int);
};
#endif // CSetupDlg_included


