#include "selectoutfile.h"

#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>

#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "stringres.h"

#ifndef rcsid
static const char rcsid[]="$Id: selectoutfile.cpp,v 2.5 2001/04/29 11:14:07 ral Exp $";
//const char*selectoutfile_rcs(){return rcsid;}
#endif

#define Inherited CSelectOutFileData

CSelectOutFile::CSelectOutFile(QWidget* parent,const char* name)
    :Inherited( parent, name,true )
{
    setCaption( GET_TEXT(72));
    OkButton->setDefault(false);
    OkButton->setEnabled(false);
    FileNameEdit->setFocus();
    CurrentSel = 0;
    SelTypeGroup->setTitle(GET_TEXT(73) );
    SelAsciiButton->setText(GET_TEXT(75) );
    //    SelHTMLButton->setText(GET_TEXT( "HTML" ) );
    //    SelLatexButton->setText(GET_TEXT( "LaTeX" ) );
    CancelButton->setText(GET_TEXT(108) );
    //OkButton->setText(GET_TEXT() );
}


CSelectOutFile::~CSelectOutFile()
{
}

void CSelectOutFile::SearchFile()
{
    QString s;
    QString pat;
    switch (CurrentSel) {
    case 0:
	pat = "*.txt";
	break;
    case 1:
	pat = "*.html";
	break;
    case 2:
	pat = "*.tex";
	break;
    default:
	pat = "*";
	break;
    }
    s = KFileDialog::getSaveFileName(0,pat);
    FileNameEdit->setText(s);
}

void CSelectOutFile::SelectionChanged(int i)
{
    CurrentSel = i;
}

void CSelectOutFile::textchange(const QString&text)
{
    if (text.length() > 0) {
	OkButton->setDefault(true);
	OkButton->setEnabled(true);
    }
    else {
	OkButton->setDefault(false);
	OkButton->setEnabled(false);
    }
    currentName = text;
}
