#include <qstring.h>
#include <qlist.h>
//#include <kmsgbox.h>
#include <kapp.h>
#include <qmessagebox.h>

#include "createtable.h"
#include "tabledescr.h"
#include "globals.h"
//#include "compoundkeydlg.h"
#include "stringres.h"
#include "my_sql.h"
#include <qcheckbox.h>                                                          
#include <qcombobox.h>                                                          
#include <qframe.h>                                                             
#include <qlabel.h>                                                             
#include <qlcdnumber.h>                                                         
#include <qlineedit.h>                                                          
#include <qlistbox.h>                                                           
#include <qpushbutton.h>                                                        
#include <qradiobutton.h>                                                       
#include <qslider.h>                                                            
#include <qlayout.h>                                                            
#include <qvariant.h>                                                           
#include <qtooltip.h>                                                           
#include <qwhatsthis.h>    


#ifndef rcsid
static const char rcsid[]="$Id: createtable.cpp,v 2.19 2001/04/08 14:00:03 ral Exp $";
//const char*createtable_rcs(){return rcsid;}
#endif

#define Inherited CModifyTable

CCreateTable::CCreateTable(smart_pointer<CMySql>& _sql_server, QWidget* parent, const char* name )
    :Inherited( _sql_server,parent, name )
{
    QString Caption = CStringRes::get_string(125);
    Caption+= " - ";
    Caption+=CStringRes::get_string(126);
    setCaption(Caption);
    TableNameEdit = new QLineEdit(this,"TableNameEdit");
    TableNameEdit->setGeometry( 280, 5, 210, 25 );
    TableNameEdit->setMinimumSize( 0, 0 );
    TableNameEdit->setMaximumSize( 32767, 32767 );
    TableNameEdit->setText( "" );
    TableNameEdit->setMaxLength( 32767 );
    TableNameEdit->setFrame( TRUE );
    TableNameEdit->setFocus();
    connect(TableNameEdit,SIGNAL(textChanged(const QString&)),SLOT(TableTextChanged(const QString&)));
    connect( CreateTableButton, SIGNAL(clicked()), SLOT(CreateTable()) );
    TopMostLayout->addWidget(TableNameEdit);
}


CCreateTable::~CCreateTable()
{

}

void CCreateTable::TableTextChanged(const QString&text)
{
    bool how =  (text.length()>0 &&
		 (CurrentTables.find(text.latin1()) == 0) );
    if (sql_server->is_system_db(DBList->currentText().latin1())) {
	how = false;
    }
    ColumnNameEdit->setEnabled(how);
    AddButton->setEnabled( how && ColumnNameEdit->text().latin1() );
}

void CCreateTable::TableTextActivate()
{
}

void CCreateTable::SetDBString(const QString&)
{
    CurrentTables.resize(0);
    if (!sql_server->get_table_list("%",DBList->currentText(),CurrentTables)) {
	return;
    }
    TableTextChanged(TableNameEdit->text());
}

void CCreateTable::AddColumn()
{
    CKeyDescriptor Key;
    QString text;

    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());
    if (desc_list.find(Desc)!=0) {
	QMessageBox::critical(this,CStringRes::get_string(6),
			      CStringRes::get_string(7));
	return;
    }
    if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	Key.set_name("PRIMARY");
	if (key_list.find(Key)) {
	    QMessageBox::critical(this,CStringRes::get_string(6),
				  CStringRes::get_string(8));
	    return;
	}
    }
    if (!ReadDescriptor(&Desc,&text,&Key))
	return;

    ColumnsList->clearSelection();
    ColumnsList->insertItem(text,-1);
    DeleteButton->setEnabled(FALSE);
    ModifyButton->setEnabled(FALSE);
    desc_list.push_back(Desc);
    CreateTableButton->setEnabled(TRUE);
    if (desc_list.size() > 1) {
	CompoundKeyButton->setEnabled(TRUE);
    }
    if (!Key_None->isChecked()) {
	key_list.push_back(Key);
    }
}

void CCreateTable::Delete_Column()
{
    int Index = ColumnsList->currentItem();
    int counter = 0;
    if (Index == -1) {
	debug("index -1");
	return;
    }
    CColumnDescriptor desc;
    desc = desc_list[Index];
    RemoveFromKey(desc.get_name());
    ColumnsList->removeItem(Index);
    counter = 0;
    for (ColumnList_iterator col_iter = desc_list.begin();col_iter != desc_list.end();++col_iter) {
	if (counter == Index) {
	    desc_list.erase(col_iter);
	    break;
	}
	++counter;
    }
    if (desc_list.size() < 2) {
	CompoundKeyButton->setEnabled(FALSE);
    }
    if (ColumnsList->count() == 0) {
	CreateTableButton->setEnabled(FALSE);
    }
    if (ColumnsList->currentItem() == -1 || ColumnsList->count() == 0) {
	DeleteButton->setEnabled(FALSE);
	ModifyButton->setEnabled(FALSE);
    }
}

void CCreateTable::CreateTable()
{
    if (sql_server->create_table(DBList->currentText(),TableNameEdit->text(),&desc_list,&key_list) == false) {
	QMessageBox::critical(this,CStringRes::get_string(121),
			      CStringRes::get_string(10));
	return;
    }
    close();
}
