// -*-Mode: C++;-*- 
/**
 * The main widget (top-level-widget) of the application
 *
 * @version $Id: MainWindow.h,v 2.10 2001/04/08 12:24:47 ral Exp $
 * @see KTopLevelWidget
 */
#ifndef CMainWindow_included
#define CMainWindow_included

#include "MainWindowData.h"
#include <string>
#include "sendmessage.h"
#include "smart_pointer.h"

class CProgramOptions;
class CMySql;
class CTableView;
class CStatusView;
class CThreadView;
class CGrantTable;
class CSqlScript;

class CMainWindow : public CMainWindowData
{
    Q_OBJECT

public:
    CMainWindow (QWidget* parent = NULL, const char* name = NULL );
    virtual ~CMainWindow();
    void append_message(const char*text);
    void set_msg_ptr(CSendMessage*ptr);
    virtual void close();

private:
    CTableView*TableView;
    CStatusView*StatusView;
    CThreadView*ThreadView;
    CGrantTable*Grants;
    CSqlScript*sql_script;

protected slots:
    void connectSql();
    void browseTables();
    void createTable();
    void createDB();
    void dispStatus();
    void view_threads();
    void accessControl();
    virtual void alterTable();

public slots:
    void disconnectSql();
    void clearOutput();
    void reload_grants();
    void flush_cache();
    void close_tables();
    void new_log();
    void shutdown();
    void drop_table();
    void drop_db();
    void rename_table();
    void sql_Edit();
    void RestoreLastConnect();

signals:
    void connected(const char*);
    void disconnected();

protected:
    CSendMessage*msg_ptr;
    smart_pointer<CMySql> sql_server;
    void CloseAllDialogs();
    void _connect(const std::string&user,const std::string&host,
		  const std::string&port,const std::string&pass);
};
#endif // CMainWindow_included
