/************************************************************************
 * kcreateinst - part of kinst package - tparams.h                      *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _TPARAMS_H
#define _TPARAMS_H

#include <stdio.h>

#include <qstring.h>

#include "../../src/kifoptions.inc"

struct tParams
{
  tKIFOptions KIFOptions;

  QString kipackpath;
  QString selfextractpath;
  QString kinstpath;
  QString kinstlocalepath;
  QString scriptpath;
  QString targetpath;

  int onefilepack;
  int selfextracting;
};

// LoadParams - Load params from file
// returns:
// 0 general failure
// 1 success
// 2 error opening file
// 3 I/O error reading file
// 4 Wrong file version
int LoadParams(tParams* params, const char* filename);

// SaveParams - Save params to file
// returns:
// 0 general failure
// 1 success
// 2 error creating/opening file
// 3 I/O error writing to file
int SaveParams(tParams* params, const char* filename);

#endif
