/************************************************************************
 * kcreateinst - part of kinst package - scriptbuild.h                  *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _SCRIPTBUILD_H
#define _SCRIPTBUILD_H

#include "tparams.h"
#include "stringfunc.h"
#include "locale.h"
#include "tgzview.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <qmessagebox.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qframe.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlabel.h>

#include <kapp.h>
#include <kfiledialog.h>

class kcreateinstScriptBuild:public QDialog
{
  Q_OBJECT
 private:
  char scriptfilename[FILENAME_MAX];
  tParams* actparams;
  QLabel* scriptfilename_label;
  QLineEdit* scriptfilename_edit;
  QPushButton* scriptfilename_button;
  QButtonGroup* typeselect_group;
  QRadioButton* MIMEinst_radio;
  QRadioButton* docinst_radio;
  QRadioButton* datadirinst_radio;
  QRadioButton* localedirinst_radio;
  QRadioButton* deletedir_radio;
  QFrame* options_frame;
  QLabel* description_label;
  QLabel* var1_label;
  QLabel* var2_label;
  QLabel* var3_label;
  QLabel* var4_label;
  QLineEdit* var1_edit;
  QLineEdit* var2_edit;
  QLineEdit* var3_edit;
  QLineEdit* var4_edit;
  QPushButton* var1_button;
  QPushButton* var2_button;
  QPushButton* var3_button;
  QPushButton* var4_button;
  QPushButton* add_button;
  QPushButton* script2arch_button;
  QPushButton* ok_button;
  QPushButton* cancel_button;
  QPushButton* help_button;
  KFileDialog* FileSelector;
  tTGZViewDlg* TGZViewer;
 private slots:
  void Browse1Pressed();
  void Browse2Pressed();
  void Browse3Pressed();
  void Browse4Pressed();
  void AddPressed();
  void Add2ArchPressed();
  void filenamebrowse();
  void typeselect_changed();
  void ok_pressed();
  void cancel_pressed();
  void help_pressed();
  void scriptfilename_changed();
 protected:
  void resizeEvent(QResizeEvent*);
 public:
  void setParams(tParams* params);
  kcreateinstScriptBuild(QWidget *parent, const char *name);
};

#endif

