/************************************************************************
 * kcreateinst - part of kinst package - dirview.h                      *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

/*

Parts of this code are taken from Troll-Tech's dirview Qt example.

*/

#ifndef _DIRVIEW_H
#define _DIRVIEW_H

#include "locale.h"

#include <qlistview.h>
#include <qstring.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qmessagebox.h>

class kcreateinstDirectory: public QListViewItem
{
public:
    kcreateinstDirectory(QListView* parent);
    kcreateinstDirectory(QListView* parent, const char* filename);
    kcreateinstDirectory(kcreateinstDirectory* parent, const char* filename);

    QString text(int column) const;

    QString fullName();

    void setOpen(bool);
    void setup();

    void setBaseDir(QString basedir);

    void dirPath(char* dir, int length);

private:
    bool baseset;
    QString startdir;
    QString dirpath;
    QFile f;
    kcreateinstDirectory *p;
    bool readable;
};

#endif
