/************************************************************************
 * kinst - KDE Application Installer - yesnodlg.cpp                     *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "yesnodlg.h"

// Meta Object Compiler code inclusion
#include "yesnodlg.moc"

// some pictures
#include "books.xpm"

tYesNoDlg::tYesNoDlg(QWidget *parent, const char* caption, const char *name)
  : QDialog(parent, name, true)
{
  setCaption(caption);
  setMinimumSize(430, 130);
  resize(430, 130);

  text_label = new QLabel(this);
  text_label->setText("");
  text_label->setAlignment(AlignVCenter | AlignHCenter);
  text_label->show();

  yes_button = new QPushButton(this);
  yes_button->setText(_i18n("Yes"));
  yes_button->show();
  connect(yes_button, SIGNAL(clicked()), this, SLOT(YesPressed()));
  
  no_button = new QPushButton(this);
  no_button->setText(_i18n("No"));
  no_button->show();
  connect(no_button, SIGNAL(clicked()), this, SLOT(NoPressed()));

  BooksImage = new QPixmap(books);

  BooksImage_Label = new QLabel(this);
  BooksImage_Label->setPixmap(*BooksImage);
  BooksImage_Label->show();

  i = 0;
}

void tYesNoDlg::resizeEvent(QResizeEvent*)
{
  yes_button->setGeometry(10,
			  height()-35,
			  90,
			  30);

  no_button->setGeometry(width()-100,
			 height()-35,
			 90,
			 30);

  text_label->setGeometry(70,
			  5,
			  width()-80,
			  height()-yes_button->height()-15);

  BooksImage_Label->setGeometry(10,
				(height()-yes_button->height())/2-24-5,
				49,
				49);
}

void tYesNoDlg::YesPressed()
{
  i = 1;
  hide();
}

void tYesNoDlg::NoPressed()
{
  i = 0;
  hide();
}

int tYesNoDlg::getYesNo(QString text_to_display)
{
  i = 0;

  text = text_to_display;

  text_label->setText(text);

  show();

  return(i);
}

