/************************************************************************
 * kinst - KDE Application Installer - kmenutree.cpp                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

/*

Parts of this code are taken from Troll-Tech's dirview Qt example.

*/

#include "locale.h"
#include "stringfunc.h"
#include "kmenutree.h"

#include <qdialog.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <ksimpleconfig.h>

#ifndef MIN_WIDTH
#define MIN_WIDTH 300
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 450
#endif

#ifndef EOL
#define EOL 10
#endif

// MOC
#include "kmenutree.moc"

tKMenuDir::tKMenuDir(tKMenuDir* parent, const char* filename)
  : QListViewItem(parent), f(filename)
{
  p = parent;
  readable = TRUE;
  baseset = false;

  dirpath = fullName();
}


tKMenuDir::tKMenuDir(QListView* parent)
  : QListViewItem(parent), f("/")
{
  p = 0;
  readable = TRUE;
  baseset = false;
  startdir = "";
}

tKMenuDir::tKMenuDir(QListView* parent, const char* filename)
  : QListViewItem(parent), f(filename)
{
  p = 0;
  readable = TRUE;
  baseset = false;
  startdir = "";
}

void tKMenuDir::setOpen(bool o)
{
  if ( o && !childCount() ) {
	QString s( fullName() );
	if(baseset) s = startdir;
	QDir thisDir( s );
	dirpath = s;
	if ( !thisDir.isReadable() ) {
	    readable = FALSE;
	    return;
	}

	const QFileInfoList * files = thisDir.entryInfoList();
	if ( files ) {
	    QFileInfoListIterator it( *files );
	    QFileInfo * f;
	    while( (f=it.current()) != 0 ) {
		++it;
		if ( f->fileName() == "." || f->fileName() == ".." )
		    ; // nothing
		else if ( f->isSymLink() )
		  ;
		else if ( f->isDir() )
		    new tKMenuDir( this, f->fileName() );
		else
		  ;
	    }
	}
    }
    QListViewItem::setOpen( o );
}

void tKMenuDir::setup()
{
    setExpandable(TRUE);
    QListViewItem::setup();
}

void tKMenuDir::setBaseDir(QString basedir)
{
  baseset = true;
  startdir = basedir;
}

void tKMenuDir::dirPath(char* dir, int length)
{
  qstrncpy(dir, dirpath, length);
}

QString tKMenuDir::fullName()
{
    QString s;
    if ( p ) {
	s = p->fullName();
	s.append( f.name() );
	s.append( "/" );
    } else {
	s = startdir + "/";
    }
    return s;
}

bool Localized(const char* dir, const char* delocalized,
	       QString* localized)
{
  QString filename;
  QString string;
  QString comparestring;
  QDir d(dir);
  const QFileInfoList* list = d.entryInfoList();
  QFileInfoListIterator it(*list);
  QFileInfo* fi;
  KSimpleConfig* config;
  bool result;

  d.setFilter(QDir::Dirs);

  filename = dir;
  filename += "/.directory";
  config = new KSimpleConfig(filename, true);
  config->setDesktopGroup();
  *localized = 
    config->readEntry("Name"); // KDE automatically localizes here
  delete config;

  comparestring = dir;
  if((comparestring.find(delocalized, 0, TRUE) != -1)
     && (localized->length() > 0))
    result = true;
  else result = false;

  while( (fi=it.current()) )
    {
      if(d.isReadable() && (result == false)
	 && (qstrcmp(fi->fileName().data(), "."))
	 && (qstrcmp(fi->fileName().data(), ".."))
	 && (fi->isDir()))
	{
	  string = dir;
	  string += "/";
	  string += fi->fileName().data();
	  result = Localized(string, delocalized, localized);
	}
      ++it;
    }

  if(qstrcmp(delocalized, "/") == 0) result = false;

  return(result);
}

QString tKMenuDir::text(int column) const
{
  QString localized_dir;
  QString kde_appsdir;

  kde_appsdir = getenv("KDEDIR");
  kde_appsdir += "/share/applnk";

  if ( column == 0 ) {
    if(Localized(kde_appsdir, f.name(), &localized_dir))
      return localized_dir;
    else
      return f.name();
  }
  else if ( readable )
    return "Directory";
  else
    return "Unreadable Directory";
}

tKMenuTreeDlg::tKMenuTreeDlg(QWidget *parent, const char *name)
  : QDialog(parent, name, true)
{
  QString kde_appsdir;

  kde_appsdir = getenv("KDEDIR");
  kde_appsdir += "/share/applnk";

  // General properties
  setCaption(_i18n("kinst - KDE Menu"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create Label
  Label = new QLabel(this);
  Label->setText(_i18n("Please choose a menu group:"));
  Label->show();

  // Create KMenu
  KMenu = new QListView(this);
  KMenu->clear();
  KMenu->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  KMenu->setTreeStepSize(20);
  KMenu->addColumn(_i18n("KDE Menu"));
  KMenu->setColumnWidthMode(0, QListView::Manual);
  KMenu->show();
  KMenuDir = new tKMenuDir(KMenu);
  KMenuDir->setBaseDir(kde_appsdir);
  KMenuDir->setOpen(true);

  // Create cancel_button
  cancel_button = new QPushButton(this);
  cancel_button->setText(_i18n("Cancel"));
  cancel_button->show();
  connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create ok button
  ok_button = new QPushButton(this);
  ok_button->setText(_i18n("OK"));
  ok_button->show();
  connect(ok_button, SIGNAL(clicked()), SLOT(ok_pressed()));
}

void tKMenuTreeDlg::resizeEvent(QResizeEvent*)
{
  // Resize Label
  Label->setGeometry(10,10,width()-20,15);

  // Resize OK button
  ok_button->setGeometry(10,
			 height()-35,
			 90,
			 30);

  // Resize cancel_button
  cancel_button->setGeometry(width()-100,
			     height()-35,
			     90,
			     30);

  // Resize KMenu
  KMenu->setGeometry(10, Label->y()+20, width()-20,
		     height()-Label->height()-ok_button->height()-30);
  KMenu->setColumnWidth(0, KMenu->width()-2);
}

void tKMenuTreeDlg::getMenuName(char* menuname)
{
  show();

  strcpy(menuname, ChosenMenu);
}

void tKMenuTreeDlg::closeEvent(QCloseEvent *e)
{
  e->ignore();
}

void tKMenuTreeDlg::ok_pressed()
{
  tKMenuDir* p;

  p = (tKMenuDir*) KMenu->currentItem();

  strcpy(ChosenMenu, p->text(0));

  hide();
}

void tKMenuTreeDlg::cancel_pressed()
{
  strcpy(ChosenMenu, "");

  hide();
}
