/************************************************************************
 * kinst - KDE Application Installer - kiss.h                           *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _KISS_H
#define _KISS_H

#include "locale.h"
#include "readfile.h"

class tKISS
{
 private:
  tKIFOptions* options;
  char* _SourceFileDir;

 public:
  // Set the Options to be used
  void setOptions(tKIFOptions* newoptions);

  // Adds application to KISS database
  // works only if source file type is TGZ
  // returns: 0 - General failure
  //          1 - success
  //          2 - wrong source file type
  int AddToKISS(const char* _dirprefix, const char* kdelnkfilename, int extnr);

  // Delete application from KISS database
  // returns: 0 - General failure
  //          1 - success
  int DeleteFromKISS(int extnr);

  tKISS(char* SourceFileDir);
  ~tKISS();
};

#endif
