/****************************************************************************************
 * Copyright (c) 2009 Seb Ruiz <ruiz@kde.org>                                           *
 * Copyright (c) 2010 Rick W. Chen <stuffcorpse@archlinux.us>                           *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#include "ComboBox.h"

#include <QKeyEvent>

namespace Amarok
{

ComboBox::ComboBox( QWidget *parent )
   : KComboBox( parent )
{
    setEditable( true );
}

void ComboBox::keyPressEvent( QKeyEvent *event )
{
    if( event->key() == Qt::Key_Escape )
    {
        event->accept();
        clearEditText();
        return;
    }
    else if( event->key() == Qt::Key_Down )
    {
        event->accept();
        emit downPressed();
        return;
    }
    KComboBox::keyPressEvent( event );
}

} // namespace AMAROK

#include "ComboBox.moc"
