/*
   SPDX-FileCopyrightText: 2024 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include "librocketchatrestapi-qt_export.h"
#include "restapiabstractjob.h"

namespace RocketChatRestApi
{
class LIBROCKETCHATRESTAPI_QT_EXPORT VideoConferenceListJob : public RestApiAbstractJob
{
    Q_OBJECT
public:
    explicit VideoConferenceListJob(QObject *parent = nullptr);
    ~VideoConferenceListJob() override;

    [[nodiscard]] bool requireHttpAuthentication() const override;

    [[nodiscard]] bool start() override;

    [[nodiscard]] QNetworkRequest request() const override;

    [[nodiscard]] bool canStart() const override;

    [[nodiscard]] QString roomId() const;
    void setRoomId(const QString &newRoomId);

Q_SIGNALS:
    void videoConferenceInfoDone(const QJsonObject &obj);

private:
    Q_DISABLE_COPY(VideoConferenceListJob)
    LIBROCKETCHATRESTAPI_QT_NO_EXPORT void onGetRequestResponse(const QString &replyErrorString, const QJsonDocument &replyJson) override;
    QString mRoomId;
};
}
