/*
   SPDX-FileCopyrightText: 2022-2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "getbannersjobtest.h"
#include "banner/getbannersjob.h"
#include "restapimethod.h"
#include <QTest>
QTEST_GUILESS_MAIN(GetBannersJobTest)
using namespace RocketChatRestApi;
GetBannersJobTest::GetBannersJobTest(QObject *parent)
    : QObject(parent)
{
}

void GetBannersJobTest::shouldHaveDefaultValue()
{
    GetBannersJob job;
    QVERIFY(!job.restApiMethod());
    QVERIFY(!job.networkAccessManager());
    QVERIFY(!job.start());
    QVERIFY(job.requireHttpAuthentication());
    QVERIFY(!job.restApiLogger());
    QVERIFY(!job.hasQueryParameterSupport());
    QVERIFY(!job.requireTwoFactorAuthentication());
}

void GetBannersJobTest::shouldGenerateRequest()
{
    GetBannersJob job;
    RestApiMethod method;
    method.setServerUrl(QStringLiteral("http://www.kde.org"));
    job.setRestApiMethod(&method);
    QNetworkRequest request = job.request();
    QCOMPARE(request.url(), QUrl(QStringLiteral("http://www.kde.org/api/v1/banners?platform=web")));
}

void GetBannersJobTest::shouldNotStarting()
{
    GetBannersJob job;

    RestApiMethod method;
    method.setServerUrl(QStringLiteral("http://www.kde.org"));
    job.setRestApiMethod(&method);

    QNetworkAccessManager mNetworkAccessManager;
    job.setNetworkAccessManager(&mNetworkAccessManager);
    QVERIFY(!job.canStart());
    const QString auth = QStringLiteral("foo");
    const QString userId = QStringLiteral("foo");
    job.setAuthToken(auth);
    QVERIFY(!job.canStart());
    job.setUserId(userId);

    QVERIFY(job.canStart());
}

#include "moc_getbannersjobtest.cpp"
