#include <errno.h>
#include <string.h>

#include <qmultilineedit.h>

#include <kapp.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kfiledialog.h>
#include <kio/netaccess.h>
#include <knotifyclient.h>

#include "kremotedemo.moc"

KRemoteDemo::KRemoteDemo (const char *name) :
  KTMainWindow (name)
{
  KStdAction::open ( this, SLOT (slotOpen()),
		     actionCollection() );
  save = KStdAction::save ( this, SLOT (slotSave()),
			    actionCollection() );
  KStdAction::quit ( kapp, SLOT (closeAllWindows()),
		     actionCollection() );
  createGUI();
  save->setEnabled (false);

  editor = new QMultiLineEdit (this);
  setView (editor);
}

void
KRemoteDemo::slotOpen()
{
  kurl = KFileDialog::getOpenURL ();

  if (kurl.isLocalFile())
    localfilename = kurl.path();
  else if (!KIO::NetAccess::download (kurl, localfilename))
    {
      KNotifyClient::event ("Could not download file.");
      return;
    }


  QFile qfile (localfilename);
   if (qfile.open (IO_ReadOnly))
    {
      char *buffer = new char [qfile.size()+1];
 
      qfile.readBlock (buffer, qfile.size());
      buffer [qfile.size()]='\0';
      editor->setText (buffer);
 
      delete buffer;
    }
  else
    {
      QString qerr;
      qerr.sprintf ("Could not open file: %s", strerror (errno));
      KNotifyClient::event (qerr);
      return;
    }
  save->setEnabled (true);
}

void
KRemoteDemo::slotSave()
{
  QFile qfile (localfilename);
   if (qfile.open (IO_ReadWrite))
    {
      qfile.writeBlock (editor->text(), 
			editor->text().length() );
      qfile.close();
    }
  else
    {
      QString qerr;
      qerr.sprintf ("Could not write file: %s", strerror (errno));
      KNotifyClient::event (qerr);
      return;
    }

  if (!kurl.isLocalFile())
    if (!KIO::NetAccess::upload (localfilename, kurl))
    {
      KNotifyClient::event ("Could not upload file.");
      return;
    }
}
  
