#include <qdragobject.h>

#include <kglobalsettings.h>

#include "kdragdemo.h"


KDragDemo::KDragDemo (QWidget *parent, const char *name) :
  QLabel (parent, name)
{
  setText ("This is draggable text.");
}


void
KDragDemo::mousePressEvent (QMouseEvent *qmouseevent)
{
  startposition = qmouseevent->pos();
}

void
KDragDemo::mouseMoveEvent (QMouseEvent *qmouseevent)
{
  int mindragdist = KGlobalSettings::dndEventDelay();

  if (qmouseevent->state() & Qt::LeftButton
      && (   qmouseevent->pos().x() > startposition.x() + mindragdist
	  || qmouseevent->pos().x() < startposition.x() - mindragdist
	  || qmouseevent->pos().y() > startposition.y() + mindragdist
	  || qmouseevent->pos().y() < startposition.y() - mindragdist) )
    {
      QTextDrag *qtextdrag = new QTextDrag( text(), this);
      qtextdrag->dragCopy();
    }
}
