from pythonqt import *
from array import *

App = Application()

#####################################################################
class TestWidget(Widget):
#####################################################################
    def __init__(s):
	Widget.__init__(s)
	save=[]
	blanks=[]

	s.setCaption("Python/Qt Widgets Demo Application")

	## skipped event filter

	## skip analog and digital clcok
	blanks.append(300,100,100,100)
	blanks.append(300,220,100,60)
	pb = PushButton("Push button 1", s)
	pb.setGeometry(10,30, 120,30)
	pb.connect("clicked",s.button1Clicked, s)
	save.append(pb)

	pb = PushButton("",s)
	pm = QPixmap()
	if( not pm.load("qt.bmp") ):
	    pb.setText("No pixmap")
	else:
	    pb.setPixmap(pm)
	pb.setGeometry(150,10, 60,60)
	pb.connect("clicked", s.button2Clicked, s)

	quitButton = PushButton("Quit",s)
	quitButton.setText("Quit")
	quitButton.setGeometry(300,30,80,30)
	quitButton.connect("clicked", App.quit, App)

	col = QColorRGB(240,10,10)
	colgrp = QColorGroupV(QColorRGB(0,0,0), col, col.light(), col.dark(),
			     col.dark(120), QColorRGB(0,0,255), 
			     QColorRGB(255,255,255))
	quitButton.setPalette( QPaletteCG(colgrp,colgrp,colgrp) )
	quitButton.setFont( QFontV("times",14,QFont.Bold,1) )

	bg = ButtonGroupTitle("Check Boxes", s)
	s.cb = [ CheckBox("Read",bg),
		 CheckBox("Write",bg),
		 CheckBox("Execute",bg) ]
	s.cb[0].setGeometry(10,15, 100,25)
	s.cb[1].setGeometry(10,45, 100,25)
	s.cb[2].setGeometry(10,75, 100,30)
	bg.setGeometry(10,80, 120,110)
	bg.connect("clicked", s.checkBoxClicked, s)

	save.append(bg)

	bg = ButtonGroupTitle("Radio Buttons", s)
	rb = RadioButton("AM",bg)
	rb.setGeometry(10,15, 100,25)
	rb = RadioButton("FM",bg)
	rb.setGeometry(10,45, 100,25)
	rb = RadioButton("Short Wave",bg)
	rb.setGeometry(10,75, 100,25)
	bg.setGeometry(140,80, 120,110)
	bg.connect("clicked", s.radioButtonClicked, s)

	lb = ListBox(s)
	items = []
	for x in range(100):
	    items.append("line " + `x`)
	lb.insertStrList(items)
	lb.removeItem(42)
	lb.insertPixmap(PixmapFile("qt.bmp"),42)
	lb.setGeometry(10,200,120,140)
	lbIH = lb.standardItemHeight()
	lb.resize(lb.width(), ((lb.height()+lbIH)/lbIH)*lbIH + 
			       lb.frameWidth()*2)
	lb.connect("selected", s.listBoxItemSelected, s)

	### Slider replaced by Scrollbar!
	sb = ScrollBarOrientation(ScrollBar.Horizontal,s,"Slider")
	sb.setGeometry(140,200, 120, sb.sizeHint().height())
	sb.connect("valueChanged",s.sliderValueChanged,s)

	combo = ComboBox(0,s)
	combo.insertList( ["True", "False", "Maybe", "Certainly", "Nope"] )
	combo.setGeometry(140,250,120,30)

	combo.connect("activatedIndex", s.comboBoxItemActivated, s)

	edCombo = ComboBox(1, s)
	edCombo.insertList( ["Permutable", "Malleable", "Adaptable", 
			     "Alterable", "Inconstant"] )

	edCombo.setGeometry(140,290,120,30)
	edCombo.connect("activatedText", s.edComboBoxItemActivated, s)
	
	le = LineEdit(s)
	le.setGeometry(140, 340, 230, 25)
	le.connect("textChanged", s.lineEditTextChanged, s)

	msgLabel = LabelT("Message:",s)
	msgLabel.setAlignment(0x22)	# Right, VCenter
	msgLabel.setGeometry(10,400, 85,30)

	s.msg = LabelT("",s)
	s.msg.setFrameStyle(Frame.Panel | Frame.Sunken)
	s.msg.setAlignment(0x24)		# Center
	s.msg.setGeometry(100,400, 300,30)
	s.msg.setFont( QFontV("times",12, QFont.Bold) )

	seperator = Frame(s)
	seperator.setFrameStyle(Frame.HLine | Frame.Sunken)
	seperator.setGeometry(5, 390, 440, 4)

	## Add blanks
	for x in blanks:
	    blank = Frame(s)
	    a,b,c,d = x
	    blank.setGeometry(a,b,c,d)
	    blank.setFrameStyle(Frame.Box | Frame.Sunken)
	    blank.setBackgroundPixmap(PixmapFile("python.bmp"))

	s.adjustSize()

#####################################################################

    def button1Clicked(s):
	s.msg.setText("The first push button was clicked")

#####################################################################

    def button2Clicked(s):
	s.msg.setText("The second push button was clicked")

#####################################################################

    def checkBoxClicked(s,id):
	string = 'Check box ' +  str(id) + ' clicked : '
	chkstring = ['-','-','-']
	if( s.cb[0].isChecked() ):
	    chkstring[0] = 'r'
	if( s.cb[1].isChecked() ):
	    chkstring[1] = 'w'
	if( s.cb[2].isChecked() ):
	    chkstring[2] = 'e'
	a = array('c',chkstring)
	chkstring = a.tostring()
	string = string + chkstring
	s.msg.setText(string)

#####################################################################
    
    def radioButtonClicked(s,id):
	s.msg.setText("Radio button " + str(id) + " clicked")

#####################################################################

    def listBoxItemSelected(s,index):
	s.msg.setText("List box item " + str(index) + " selected")

#####################################################################

    def lineEditTextChanged(s, text):
	s.msg.setText("Line edit text: " + text)

#####################################################################

    def sliderValueChanged(s, i):
	s.msg.setText("New slider value " + str(i))

#####################################################################

    def comboBoxItemActivated(s, i):
	s.msg.setText("Combo box item " + str(i) + " activated")

#####################################################################

    def edComboBoxItemActivated(s, t):
	s.msg.setText("Editable Combo Box set to " + t)

#####################################################################

tw = TestWidget()
tw.show()
App.setMainWidget(tw)
App.execLoop()






