#include "Widget.h"
#include <qscrbar.h>

class ScrollBar : public Widget // multiple inheritance not supported!
{				// so we'll emulate it!
  Q_OBJECT;
public:
  enum Orientation { Horizontal, Vertical };


  ScrollBar( Widget *parent=0, const char *name=0 );
  ScrollBar( Orientation, 
	     Widget *parent=0, 
	     const char *name=0 );
  ScrollBar( int minValue, int maxValue, 
	     int LineStep, int PageStep,
	     int value, Orientation,
	     Widget *parent=0, const char *name=0 );
  
  void        setOrientation( Orientation );
  Orientation orientation() const;
  void        setTracking( int enable );
  bool        tracking() const;
  
  bool        draggingSlider() const;
  
  void        setPalette( const QPalette & );
  QSize       sizeHint() const;
  

  // Stuff that should be inherited from QRangeControl
  int value() const;
  void setValue(int value);
  void addPage();
  void subtractPage();
  void addLine();
  void subtractLine();
  int minValue() const;
  int maxValue() const;
  void setRange(int minValue, int maxValue);
  int lineStep() const;
  int pageStep() const;
  void setSteps(int line, int page);

public slots:
  //signals:
  void        valueChanged( int value );
  void        sliderPressed();
  void        sliderMoved( int value );
  void        sliderReleased();
  void        nextLine();
  void        prevLine();
  void        nextPage();
  void        prevPage();

public:
  QScrollBar *scrollbar;

  virtual void setWidget(QScrollBar *);
};
