#include "MultiLineEdit.h"

MultiLineEdit::MultiLineEdit(Widget *parent=0, const char *name=0)
{
  if(parent)
    setWidget(new QMultiLineEdit(parent->widget, name));
  else
    setWidget(new QMultiLineEdit(NULL, name));
}

MultiLineEdit::~MultiLineEdit()
{
  // nothing
}

void MultiLineEdit::setWidget(QMultiLineEdit *mle)
{
  multilineedit = mle;
  QObject::connect(multilineedit, SIGNAL(textChanged()),
		   this,SLOT(textChanged()));
  QObject::connect(multilineedit, SIGNAL(returnPressed()),
		   this,SLOT(returnPressed()));

  TableView::setWidget((QTableView*)mle);
}

const char *MultiLineEdit::textLine(int line) const
{
  return multilineedit->textLine(line);
}

const char *MultiLineEdit::text() const
{
  return strdup((const char*)multilineedit->text());
}

int MultiLineEdit::numLines() const
{
  return multilineedit->numLines();
}

bool MultiLineEdit::isReadOnly() const
{
  return multilineedit->isReadOnly();
}

bool MultiLineEdit::isOverwriteMode() const
{
  return multilineedit->isOverwriteMode();
}

void MultiLineEdit::setFont(const QFont& font)
{
  multilineedit->setFont(font);
}

void MultiLineEdit::insertLine(const char* s, int line = -1)
{
  multilineedit->insertLine(s,line);
}

void MultiLineEdit::insertAt(const char* s, int line, int col)
{
  multilineedit->insertAt(s,line,col);
}

void MultiLineEdit::removeLine(int line)
{
  multilineedit->removeLine(line);
}

void MultiLineEdit::setCursorPosition(int line, int col, int mark)
{
  multilineedit->setCursorPosition(line,col,mark);
}

void MultiLineEdit::getCursorPosition(int *line, int *col)
{
  multilineedit->getCursorPosition(line,col);
}

bool MultiLineEdit::atBeginning() const
{
  return multilineedit->atBeginning();
}

bool MultiLineEdit::atEnd() const
{
  return multilineedit->atEnd();
}

bool MultiLineEdit::autoUpdate() const
{
  return multilineedit->autoUpdate();
}

void MultiLineEdit::setAutoUpdate(int au)
{
  multilineedit->setAutoUpdate(au);
}

// SLOTS
void MultiLineEdit::clear()
{
  multilineedit->clear();
}

void MultiLineEdit::setText(const char *text)
{
  multilineedit->setText(text);
}

void MultiLineEdit::append(const char *text)
{
  multilineedit->append(text);
}

void MultiLineEdit::deselect()
{
  multilineedit->deselect();
}

void MultiLineEdit::selectAll()
{
  multilineedit->selectAll();
}

void MultiLineEdit::setReadOnly(int ro)
{
  multilineedit->setReadOnly(ro);
}

void MultiLineEdit::setOverwriteMode(int ow)
{
  multilineedit->setOverwriteMode(ow);
}

void MultiLineEdit::paste()
{
  multilineedit->paste();
}

void MultiLineEdit::copyText()
{
  multilineedit->copyText();
}

void MultiLineEdit::cut()
{
  multilineedit->cut();
}

// SIGNALS
void MultiLineEdit::textChanged()
{
  emit("textChanged",NULL);
}

void MultiLineEdit::returnPressed()
{
  emit("returnPressed",NULL);
}




