#include <Python.h>
#include "LineEdit.h"

LineEdit::LineEdit(Widget *parent, const char *name)
  : Widget("") // use abstract widget constructor
{
  if(parent)
    lineedit = new QLineEdit(parent->widget,name);
  else
    lineedit = new QLineEdit(NULL, name);

  Widget::setWidget((QWidget*)lineedit);

  QObject::connect(lineedit, SIGNAL(textChanged(const char*)), 
		   this, SLOT(textChanged(const char*)));
  QObject::connect(lineedit, SIGNAL(returnPressed()), 
		   this, SLOT(returnPressed()));

}

LineEdit::~LineEdit()
{
}

const char *LineEdit::text()
{
  return lineedit->text();
}

int LineEdit::maxLength()
{
  return lineedit->maxLength();
}

void LineEdit::setMaxLength(int maxlength)
{
  lineedit->setMaxLength(maxlength);
}

void LineEdit::setFrame(int f)
{
  lineedit->setFrame(f);
}

bool LineEdit::frame() const
{
  return lineedit->frame();
}

void LineEdit::setEchoMode(enum EchoMode newechomode)
{
  lineedit->setEchoMode((QLineEdit::EchoMode)newechomode);
}

LineEdit::EchoMode LineEdit::echoMode() const
{
  return (LineEdit::EchoMode)lineedit->echoMode();
}

void LineEdit::setText(const char *text)
{
  lineedit->setText(text);
}

void LineEdit::selectAll()
{
  lineedit->selectAll();
}

void LineEdit::deselect()
{
  lineedit->deselect();
}

void LineEdit::textChanged(const char *newtext)
{
  PyObject *args;
  args = Py_BuildValue("(s)",newtext);
  emit("textChanged",args);
  Py_XDECREF(args);
}

void LineEdit::returnPressed()
{
  emit("returnPressed",NULL);
}

