#include <Python.h>
#include "ButtonGroup.h"
#include "Application.h"


ButtonGroup::ButtonGroup (Widget* parent=0, const char* name=0)
{
  if(parent)
    buttongroup = new QButtonGroup(parent->widget,name);
  else
    buttongroup = new QButtonGroup(NULL,name);

  setWidget(buttongroup);
}
 
ButtonGroup::ButtonGroup (const char* title, Widget* parent=0, const char* name=0)
{
  if(parent)
    buttongroup = new QButtonGroup(title,parent->widget,name);
  else
    buttongroup = new QButtonGroup(title,NULL,name);

  setWidget(buttongroup);
}


void ButtonGroup::setWidget(QButtonGroup *bg)
{
  buttongroup = bg;
  QObject::connect(buttongroup,SIGNAL(pressed(int)),this,SLOT(pressed(int)));
  QObject::connect(buttongroup,SIGNAL(released(int)),this,SLOT(released(int)));
  QObject::connect(buttongroup,SIGNAL(clicked(int)),this,SLOT(clicked(int)));
  GroupBox::setWidget((QGroupBox*)buttongroup);
}

ButtonGroup::~ButtonGroup ()
{
}

bool ButtonGroup::isExclusive () const
{
  return buttongroup->isExclusive();
}
 
void ButtonGroup::setExclusive (bool e)
{
  buttongroup->setExclusive(e);
}

int ButtonGroup::insert (Button* b, int id=-1)
{
  return buttongroup->insert(b->button, id);
}
 
void ButtonGroup::remove (Button* b)
{
  buttongroup->remove(b->button);
}

Button* ButtonGroup::find (int id) const
{
  QWidget *got = (QWidget*)buttongroup->find(id);

  Widget *w;
  for(w = Widgets->first(); w!=0; w = Widgets->next())
    {
      if(w->widget == got)
	return (Button*)w;
    }
  return NULL;
}
 


  //Signals
void ButtonGroup::pressed (int id)
{
  PyObject *args;
  args = Py_BuildValue("(i)",id);
  emit("pressed",args);
  Py_XDECREF(args);
}

void ButtonGroup::released (int id)
{
  PyObject *args;
  args = Py_BuildValue("(i)",id);
  emit("released",args);
  Py_XDECREF(args);
}
 
void ButtonGroup::clicked (int id)
{
  PyObject *args;
  args = Py_BuildValue("(i)",id);
  emit("clicked",args);
  Py_XDECREF(args);
}



