/* 
*/

#include <qapp.h>
#include <qdir.h>
#include <qpainter.h>
#include <qwmatrix.h>
#include <kpixmap.h>
#include <klocale.h>
#include <kapp.h>
#include <errno.h>

#include "knewiconloader.h"

KNewIconLoader::KNewIconLoader( KConfig *conf, const QString &app_name, const QString &var_name )
 : KIconLoader( conf, app_name, var_name )
{
  handle = 0;
  loadLibrary("libktoolbaricons.so.0");
}


KNewIconLoader::KNewIconLoader()
{
  handle = 0;
  loadLibrary("libktoolbaricons.so.0");
}

KNewIconLoader::~KNewIconLoader()
{
  if(!handle)
    return;

  (*xpm_fini)();

  LIB::unloadLibrary(handle);

}

QPixmap KNewIconLoader::loadInternal ( const QString &name, int w,  int h )
{
  QPixmap *pix = 0;
  KPixmap new_xpm;

  int index;

  if ( (index = name_list.find(name)) < 0)
  {
  
    if(handle && name.right(4) != ".xpm")
    {
      if ( (index = libicons.find(name)) >= 0)
      {
        pix = (*xpm_icon)(libicons.at(index));
      }
    }
    else
    {

      QString full_path;
      QFileInfo finfo;
    
      pix = new QPixmap;
    
      if( name.left(1) == '/' )
      {
        full_path = name;
      }
      else
      {

        QStrListIterator it( pixmap_dirs );
      
        while ( it.current() )
        {
	
	  full_path = it.current();
  	  full_path += '/';
	  full_path += name;
	  finfo.setFile( full_path );
	  if ( finfo.exists() )
	      break;
	  ++it;
        }
      }
      new_xpm.load( full_path, 0, KPixmap::LowColor );
      *pix = new_xpm;
    }
    
    if( !(pix->isNull()) ){
      
      name_list.append(name);
      pixmap_list.append(pix);

    } 
    else
    {
      if(pix)
        delete pix;
      return new_xpm;
    }
  }
  else{

    pix = pixmap_list.at(index);
  }
  

  if (pix && !pix->isNull() && w > 0 && h > 0 &&  
      (pix->width() > w || pix->height() > h)){

    QWMatrix m;
    m.scale(w/(float)pix->width(), h/(float)pix->height());

    return pix->xForm(m);

  }

  return *pix;
}

bool KNewIconLoader::loadLibrary(const char *lib)
{
  if(handle)
  {
    (*xpm_fini)();
    LIB::unloadLibrary(handle);
  }

  handle = LIB::loadLibrary(lib, LIB::ResolveLazy);
  if (!handle)
  {
    QString msg = i18n("Couldn't open library:\n");
    msg += LIB::error();
    debug(msg.data());
    return false;
  }

  xpm_init = LIB::getSymbol(handle, QString("xpm_init"));
  if ((error = (char*)LIB::error()) != 0)
  {                  
    QString msg = i18n("Couldn't load symbol \"xpm_init\"\n");
    msg += error;
    debug(msg.data());
    return false;
  }

  (*xpm_init)();

  xpm_fini = LIB::getSymbol(handle, QString("xpm_fini"));
  if ((error = (char*)LIB::error()) != 0)
  {                  
    QString msg = "Couldn't load symbol \"xpm_fini\"\n";
    msg += error;
    debug(msg.data());
    return false;
  }

  xpm_icon = LIB::getSymbol(handle, QString("xpm_icon"));
  if ((error = (char*)LIB::error()) != 0)
  {                  
    QString msg = i18n("Couldn't load symbol \"xpm_icon\"\n");
    msg += error;
    debug(msg.data());
    return false;
  }

  xpm_names = LIB::getSymbol(handle, QString("xpm_names"));
  if ((error = (char*)LIB::error()) != 0)
  {                  
    QString msg = i18n("Couldn't load symbol \"xpm_names\"\n");
    msg += error;
    debug(msg.data());
    return false;
  }

  libicons = (*xpm_names)(libicons);

  return true;
}


