#ifndef _TABBAR_H_
#define _TABBAR_H_

#include <Python.h>
#include <qtabbar.h>
#include "Baseobject.h"


class TabBar : public QTabBar, BaseObject
{
  Q_OBJECT

  public:

  TabBar(QWidget *parent=0, const char *name=0)
    : QTabBar(parent, name), BaseObject()
  {
    connect(this, SIGNAL(selected(int)), this, SLOT(sigSelected(int)));
  }
  ~TabBar() {};

  int _addTab(const char *tabname );
  char *_tab( int );


  protected slots:

    void sigSelected(int value) {
      PyObject *arg = Py_BuildValue("(i)",value);
      _emit("selected", arg);
      Py_DECREF(arg);
    };
};

#endif


