%module Painter

%{
#include <qpainter.h>
#include <qpaintd.h>
#include "Object.h"
#include "Baseobject.h"
%}


%include Constants.i
%import Object.i
%import Paintdevice.i
%import Pen.i
%import Region.i
%import Baseobject.i
%import Brush.i
%import WMatrix.i


class QPainter : public BaseObject		
{
public:
    QPainter();
%name(QPainterPaintDevice)    QPainter( const QPaintDevice * );
   ~QPainter();

    bool	begin( const QPaintDevice * );
    bool	end();
    QPaintDevice *device() const;

    static void redirect( QPaintDevice *pdev, QPaintDevice *replacement );

    bool	isActive() const;

    void	flush();
    void	save();
    void	restore();

  // Drawing tools

    QFontMetrics fontMetrics()	const;
    QFontInfo	 fontInfo()	const;

    const QFont &font()		const;
    void	setFont( const QFont & );
    const QPen &pen()		const;
    void	setPen( const QPen & );
%name(setPenStyle)    void	setPen( PenStyle );
%name(setPenColor)    void	setPen( const QColor & );
    const QBrush &brush()	const;
    void	setBrush( const QBrush & );
%name(setBrushStyle)    void	setBrush( BrushStyle );
%name(setBrushColor)    void	setBrush( const QColor & );

  // Drawing attributes/modes

    const QColor &backgroundColor() const;
    void	setBackgroundColor( const QColor & );
    BGMode	backgroundMode() const;
    void	setBackgroundMode( BGMode );
    RasterOp	rasterOp()	const;
    void	setRasterOp( RasterOp );
    const QPoint &brushOrigin() const;
    void	setBrushOrigin( const QPoint & );

    void	setViewXForm( bool );		// set xform on/off
    bool	hasViewXForm() const;
    QRect	window()       const;		// get window
    void	setWindow( const QRect & );	// set window
    QRect	viewport()   const;		// get viewport
    void	setViewport( const QRect & );	// set viewport

    void	setWorldXForm( bool );		// set world xform on/off
    bool	hasWorldXForm() const;
    const QWMatrix &worldMatrix() const;	// get/set world xform matrix
    void	setWorldMatrix( const QWMatrix &, bool concat=FALSE );

    void	translate( float dx, float dy );
    void	scale( float sx, float sy );
    void	shear( float sh, float sv );
    void	rotate( float a );
    void	resetXForm();

    QPoint	xForm( const QPoint & ) const;	// map virtual -> device
%name(xFormRect)    QRect	xForm( const QRect & )	const;
%name(xFormPoints)    QPointArray xForm( const QPointArray & ) const;
    QPoint	xFormDev( const QPoint & ) const; // map device -> virtual
%name(xFormDevRect)    QRect	xFormDev( const QRect & )  const;
%name(xFormDevPoints)    QPointArray xFormDev( const QPointArray & ) const;

  // Clipping

    void	setClipping( bool );		// set clipping on/off
    bool	hasClipping() const;
    const QRegion &clipRegion() const;
    void	setClipRect( const QRect & );	// set clip rectangle
    void	setClipRegion( const QRegion &);// set clip region

  // Graphics drawing functions

    void	drawPoint( const QPoint & );
    void	drawPoints( const QPointArray& a,
			    int index=0, int npoints=-1 );
    void	moveTo( const QPoint & );
    void	lineTo( const QPoint & );
    void	drawLine( const QPoint &, const QPoint & );
    void	drawRect( const QRect & );
    void	drawWinFocusRect( const QRect & );
%name(drawWinFocusRectColor)    void	drawWinFocusRect( const QRect &, 
				  const QColor &bgColor );
    void	drawRoundRect( const QRect &, int, int );
    void	drawEllipse( const QRect & );
    void	drawArc( const QRect &, int a, int alen );
    void	drawPie( const QRect &, int a, int alen );
    void	drawChord( const QRect &, int a, int alen );
    void	drawLineSegments( const QPointArray &,
				  int index=0, int nlines=-1 );
    void	drawPolyline( const QPointArray &,
			      int index=0, int npoints=-1 );
    void	drawPolygon( const QPointArray &, bool winding=FALSE,
			     int index=0, int npoints=-1 );
    void	drawQuadBezier( const QPointArray &, int index=0 );
%name(drawPixmapRect)    void	drawPixmap( const QPoint &, const QPixmap &,
			    const QRect &sr );
    void	drawPixmap( const QPoint &, const QPixmap & );
    void	drawPicture( const QPicture & );

    void	fillRect( const QRect &, const QBrush & );
    void	eraseRect( const QRect & );

  // Text drawing functions

    void	drawText( const QPoint &, const char *str, int len = -1 );
%name(drawTextRect)    void	drawText( const QRect &, int flags,
			  const char *str, int len = -1, QRect *br=0,
			  char **internal=0 );

  // Text drawing functions

    QRect	boundingRect( const QRect &, int flags,
			      const char *str, int len = -1, char **intern=0 );

    int		tabStops() const;
    void	setTabStops( int );
    int	       *tabArray() const;
    void	setTabArray( int * );

    static void initialize();
    static void cleanup();
};
