%module Font

%{
#include <qfont.h>
#include "Object.h"
%}


%import Object.i


class QFont
{
public:
    enum StyleHint { Helvetica, Times, Courier, OldEnglish,  System, AnyStyle,
		     SansSerif	= Helvetica,
		     Serif	= Times,
		     TypeWriter = Courier,
		     Decorative = OldEnglish};

    enum Weight	   { Light = 25, Normal = 50, DemiBold = 63,
		     Bold  = 75, Black	= 87 };

    enum CharSet   { Latin1, ISO_8859_1 = Latin1, AnyCharSet,
		     Latin2, ISO_8859_2 = Latin2,
		     Latin3, ISO_8859_3 = Latin3,
		     Latin4, ISO_8859_4 = Latin4,
		     Latin5, ISO_8859_5 = Latin5,
		     Latin6, ISO_8859_6 = Latin6,
		     Latin7, ISO_8859_7 = Latin7,
		     Latin8, ISO_8859_8 = Latin8,
		     Latin9, ISO_8859_9 = Latin9 };

    QFont( const char *family, int pointSize = 12,
	   int weight = Normal, bool italic = FALSE );
%name(QFontCharset)    QFont( const char *family, int pointSize,
	   int weight, bool italic, CharSet charSet );
%name(QFontCopy)    QFont( const QFont & );
    ~QFont();

    const char *family()	const;
    void	setFamily( const char * );
    int		pointSize()	const;
    void	setPointSize( int );
    int		weight()	const;
    void	setWeight( int );
    bool	bold()		const;
    void	setBold( bool );
    bool	italic()	const;
    void	setItalic( bool );
    bool	underline()	const;
    void	setUnderline( bool );
    bool	strikeOut()	const;
    void	setStrikeOut( bool );
    bool	fixedPitch()	const;
    void	setFixedPitch( bool );
    StyleHint	styleHint()	const;
    void	setStyleHint( StyleHint );
    CharSet	charSet()	const;
    void	setCharSet( CharSet );
    bool	rawMode()	const;
    void	setRawMode( bool );

    bool	exactMatch()	const;

    QString	key() const;

    static const QFont &defaultFont();
    static void setDefaultFont( const QFont & );

    static const char  *substitute( const char *familyName );
    static void insertSubstitution( const char *, const char * );
    static void removeSubstitution( const char * );
    static void listSubstitutions( QStrList * );

    static void initialize();
    static void cleanup();
    static void cacheStatistics();
};
