import libqtpythonc
from baseobject import *


class WMatrixPtr(BaseObjectPtr):

    def __init__(self,this,name=""):
        BaseObjectPtr.__init__(self,name)
        self.this = this
        self.thisown = 0

    def setMatrix(self,arg0,arg1,arg2,arg3,arg4,arg5):
        val = libqtpythonc.QWMatrix_setMatrix(self.this,arg0,arg1,arg2,arg3,arg4,arg5)
        return val

    def m11(self):
        val = libqtpythonc.QWMatrix_m11(self.this)
        return val

    def m12(self):
        val = libqtpythonc.QWMatrix_m12(self.this)
        return val

    def m21(self):
        val = libqtpythonc.QWMatrix_m21(self.this)
        return val

    def m22(self):
        val = libqtpythonc.QWMatrix_m22(self.this)
        return val

    def dx(self):
        val = libqtpythonc.QWMatrix_dx(self.this)
        return val

    def dy(self):
        val = libqtpythonc.QWMatrix_dy(self.this)
        return val

    def map(self,arg0,arg1,arg2,arg3):
        val = libqtpythonc.QWMatrix_map(self.this,arg0,arg1,arg2,arg3)
        return val

    def mapFloat(self,arg0,arg1,arg2,arg3):
        val = libqtpythonc.QWMatrix_mapFloat(self.this,arg0,arg1,arg2,arg3)
        return val

    def mapPoint(self,arg0):
        val = libqtpythonc.QWMatrix_mapPoint(self.this,arg0)
        return val

    def mapRect(self,arg0):
        val = libqtpythonc.QWMatrix_mapRect(self.this,arg0)
        return val

    def mapPoints(self,arg0):
        val = libqtpythonc.QWMatrix_mapPoints(self.this,arg0)
        return val

    def reset(self):
        val = libqtpythonc.QWMatrix_reset(self.this)
        return val

    def translate(self,arg0,arg1):
        val = libqtpythonc.QWMatrix_translate(self.this,arg0,arg1)
        val = WMatrixPtr(val)
        return val

    def scale(self,arg0,arg1):
        val = libqtpythonc.QWMatrix_scale(self.this,arg0,arg1)
        val = WMatrixPtr(val)
        return val

    def shear(self,arg0,arg1):
        val = libqtpythonc.QWMatrix_shear(self.this,arg0,arg1)
        val = WMatrixPtr(val)
        return val

    def rotate(self,arg0):
        val = libqtpythonc.QWMatrix_rotate(self.this,arg0)
        val = WMatrixPtr(val)
        return val

    def invert(self,*args):
        val = apply(libqtpythonc.QWMatrix_invert,(self.this,)+args)
        val = WMatrixPtr(val)
        val.thisown = 1
        return val

    def __repr__(self):
        return "<WMatrix instance at %s>" % self.this

class WMatrix(WMatrixPtr):
    def __init__(self,name="") :
        QMatrixPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QWMatrix()
        self.thisown = 1



def WMatrixInit(arg0,arg1,arg2,arg3,arg4,arg5,name="") :
    val = WMatrixPtr(libqtpythonc.new_QWMatrixInit(arg0,arg1,arg2,arg3,arg4,arg5),name)
    val.thisown = 1
    return val

