import libqtpythonc
from baseobject import *
from object import *
from color import *
from pixmap import *
from colorgroup import *


class WidgetPtr(ObjectPtr) :

    FixedColor = libqtpythonc.QWidget_FixedColor
    FixedPixmap = libqtpythonc.QWidget_FixedPixmap
    NoBackground = libqtpythonc.QWidget_NoBackground

    PaletteForeground = libqtpythonc.QWidget_PaletteForeground
    PaletteBackground = libqtpythonc.QWidget_PaletteBackground
    PaletteLight = libqtpythonc.QWidget_PaletteLight
    PaletteMidlight = libqtpythonc.QWidget_PaletteMidlight
    PaletteDark = libqtpythonc.QWidget_PaletteDark
    PaletteMid = libqtpythonc.QWidget_PaletteMid
    PaletteText = libqtpythonc.QWidget_PaletteText
    PaletteBase = libqtpythonc.QWidget_PaletteBase

    NoFocus = libqtpythonc.QWidget_NoFocus
    TabFocus = libqtpythonc.QWidget_TabFocus
    ClickFocus = libqtpythonc.QWidget_ClickFocus
    StrongFocus = libqtpythonc.QWidget_StrongFocus

    _classname = "Widget"

    def __init__(self,this,name=""):
	ObjectPtr.__init__(self,this,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QWidget(self.this)

    def winId(self):
        return libqtpythonc.QWidget_winId(self.this)

    def style(self):
        return libqtpythonc.QWidget_style(self.this)

    def setStyle(self,style):
        libqtpythonc.QWidget_setStyle(self.this,style)

    def isTopLevel(self):
        return libqtpythonc.QWidget_isTopLevel(self.this)

    def isModal(self):
        return libqtpythonc.QWidget_isModal(self.this)

    def isPopup(self):
        return libqtpythonc.QWidget_isPopup(self.this)

    def isDesktop(self):
        return libqtpythonc.QWidget_isDesktop(self.this)

    def isEnabled(self):
        return libqtpythonc.QWidget_isEnabled(self.this)

    def setEnabled(self,enabled):
        libqtpythonc.QWidget_setEnabled(self.this,enabled)

    def frameGeometry(self):
        return libqtpythonc.QWidget_frameGeometry(self.this)

    def geometry(self):
        return libqtpythonc.QWidget_geometry(self.this)

    def x(self):
        return libqtpythonc.QWidget_x(self.this)

    def y(self):
        return libqtpythonc.QWidget_y(self.this)

    def pos(self):
        return libqtpythonc.QWidget_pos(self.this)

    def size(self):
        return libqtpythonc.QWidget_size(self.this)

    def width(self):
        return libqtpythonc.QWidget_width(self.this)

    def height(self):
        return libqtpythonc.QWidget_height(self.this)

    def rect(self):
        return libqtpythonc.QWidget_rect(self.this)

    def childrenRect(self):
        return libqtpythonc.QWidget_childrenRect(self.this)

    def minimumSize(self):
        return libqtpythonc.QWidget_minimumSize(self.this)

    def maximumSize(self):
        return libqtpythonc.QWidget_maximumSize(self.this)

    def setMinimumSize(self,size):
        libqtpythonc.QWidget_setMinimumSize(self.this,size[0],size[1])

    def setMaximumSize(self,size):
        libqtpythonc.QWidget_setMaximumSize(self.this,size[0],size[1])

    def setMinimumWidth(self,w):
        libqtpythonc.QWidget_setMinimumWidth(self.this,w)

    def setMinimumHeight(self,h):
        libqtpythonc.QWidget_setMinimumHeight(self.this,h)

    def setMaximumWidth(self,w):
        libqtpythonc.QWidget_setMaximumWidth(self.this,w)

    def setMaximumHeight(self,h):
        libqtpythonc.QWidget_setMaximumHeight(self.this,h)

    def sizeIncrement(self):
        return libqtpythonc.QWidget_sizeIncrement(self.this)

    def setSizeIncrement(self,increment):
        libqtpythonc.QWidget_setSizeIncrement(self.this,increment[0],increment[1])

    def setFixedSize(self,size):
        libqtpythonc.QWidget_setFixedSize(self.this,size[0],size[1])

    def setFixedWidth(self,w):
        libqtpythonc.QWidget_setFixedWidth(self.this,w)

    def setFixedHeight(self,h):
        libqtpythonc.QWidget_setFixedHeight(self.this,h)

    def mapToGlobal(self,point):
        return libqtpythonc.QWidget_mapToGlobal(self.this,point)

    def mapFromGlobal(self,point):
        return libqtpythonc.QWidget_mapFromGlobal(self.this,point)

    def mapToParent(self,point):
        return libqtpythonc.QWidget_mapToParent(self.this,point)

    def mapFromParent(self,point):
        return libqtpythonc.QWidget_mapFromParent(self.this,point)

    def topLevelWidget(self):
        return WidgetPtr(libqtpythonc.QWidget_topLevelWidget(self.this))

    def backgroundMode(self):
        return libqtpythonc.QWidget_backgroundMode(self.this)

    def setBackgroundMode(self,mode):
        libqtpythonc.QWidget_setBackgroundMode(self.this,mode)

    def backgroundColor(self):
        val = ColorPtr(libqtpythonc.QWidget_backgroundColor(self.this))
        val.thisown = 0
        return val

    def foregroundColor(self):
        val = ColorPtr(libqtpythonc.QWidget_foregroundColor(self.this))
        val.thisown = 0
        return val

    def setBackgroundColor(self,color):
        libqtpythonc.QWidget_setBackgroundColor(self.this,color.this)

    def backgroundPixmap(self):
        val = PixmapPtr(libqtpythonc.QWidget_backgroundPixmap(self.this))
	val.thisown = 0
	return val

    def setBackgroundPixmap(self,pixmap):
        libqtpythonc.QWidget_setBackgroundPixmap(self.this,pixmap.this)
 
    def colorGroup(self):
        return ColorGroupPtr(libqtpythonc.QWidget_colorGroup(self.this))

    def palette(self):
        return PalettePtr(libqtpythonc.QWidget_palette(self.this))

    def setPalette(self,palette):
        libqtpythonc.QWidget_setPalette(self.this,palette.this)

    def font(self):
        val = FontPtr(libqtpythonc.QWidget_font(self.this))
        val.thisown = 0
        return val

    def setFont(self,font):
        libqtpythonc.QWidget_setFont(self.this,font.this)
 
    def fontMetrics(self):
        return libqtpythonc.QWidget_fontMetrics(self.this)

    def fontInfo(self):
        return libqtpythonc.QWidget_fontInfo(self.this)

    def cursor(self):
        return libqtpythonc.QWidget_cursor(self.this)

    def setCursor(self,cursor):
        libqtpythonc.QWidget_setCursor(self.this,cursor.this)

    def caption(self):
        return libqtpythonc.QWidget_caption(self.this)

    def setCaption(self,caption):
        libqtpythonc.QWidget_setCaption(self.this,caption)

    def icon(self):
        val = PixmapPtr(libqtpythonc.QWidget_icon(self.this))
	val.thisown = 0
	return val

    def setIcon(self,pixmap):
        libqtpythonc.QWidget_setIcon(self.this,pixmap.this)

    def iconText(self):
        return libqtpythonc.QWidget_iconText(self.this)

    def setIconText(self,text):
        libqtpythonc.QWidget_setIconText(self.this,text)

    def hasMouseTracking(self):
        return libqtpythonc.QWidget_hasMouseTracking(self.this)

    def setMouseTracking(self,enabled):
        libqtpythonc.QWidget_setMouseTracking(self.this,enabled)

    def isActiveWindow(self):
        return libqtpythonc.QWidget_isActiveWindow(self.this)

    def setActiveWindow(self):
        libqtpythonc.QWidget_setActiveWindow(self.this)

    def isFocusEnabled(self):
        return libqtpythonc.QWidget_isFocusEnabled(self.this)

    def focusPolicy(self):
        return libqtpythonc.QWidget_focusPolicy(self.this)

    def setFocusPolicy(self,policy):
        libqtpythonc.QWidget_setFocusPolicy(self.this,policy)

    def hasFocus(self):
        return libqtpythonc.QWidget_hasFocus(self.this)

    def setFocus(self):
        libqtpythonc.QWidget_setFocus(self.this)

    def clearFocus(self):
        libqtpythonc.QWidget_clearFocus(self.this)

    def setFocusProxy(self,proxy):
        libqtpythonc.QWidget_setFocusProxy(self.this,proxy.this)

    def focusProxy(self):
        return libqtpythonc.QWidget_focusProxy(self.this)

    def grabMouse(self):
        libqtpythonc.QWidget_grabMouse(self.this)

    def grabMouseCursor(self,grab):
        libqtpythonc.QWidget_grabMouseCursor(self.this,grab)

    def releaseMouse(self):
        libqtpythonc.QWidget_releaseMouse(self.this)

    def grabKeyboard(self):
        libqtpythonc.QWidget_grabKeyboard(self.this)

    def releaseKeyboard(self):
        libqtpythonc.QWidget_releaseKeyboard(self.this)

    def isUpdatesEnabled(self):
        return libqtpythonc.QWidget_isUpdatesEnabled(self.this)

    def setUpdatesEnabled(self,enabled):
        libqtpythonc.QWidget_setUpdatesEnabled(self.this,enabled)

    def update(self):
        libqtpythonc.QWidget_update(self.this)

    def updateRect(self,arg):
        libqtpythonc.QWidget_updateRect(self.this,arg[0],arg[1],arg[2],arg[3])

    def repaint(self,*args):
        apply(libqtpythonc.QWidget_repaint,(self.this,)+args)

    def repaintRect(self,arg0,arg1,arg2,arg3,*args):
        apply(libqtpythonc.QWidget_repaintRect,(self.this,arg0,arg1,arg2,arg3,)+args)

    def show(self):
        libqtpythonc.QWidget_show(self.this)

    def hide(self):
        libqtpythonc.QWidget_hide(self.this)

    def iconify(self):
        libqtpythonc.QWidget_iconify(self.this)

    def close(self,force=0):
        return libqtpythonc.QWidget_close(self.this,force)

    def isVisible(self):
        return libqtpythonc.QWidget_isVisible(self.this)

    def isVisibleToTLW(self):
        return libqtpythonc.QWidget_isVisibleToTLW(self.this)

    def raiseWidget(self):
        libqtpythonc.QWidget_raise(self.this)

    def lowerWidget(self):
        libqtpythonc.QWidget_lower(self.this)

    def move(self,pos):
        libqtpythonc.QWidget_move(self.this,pos[0],pos[1])

    def resize(self,size):
        libqtpythonc.QWidget_resize(self.this,size[0],size[1])

    def setGeometry(self,rect):
        libqtpythonc.QWidget_setGeometry(self.this,rect[0],rect[1],rect[2],rect[3])

    def sizeHint(self):
        return libqtpythonc.QWidget_sizeHint(self.this)

    def adjustSize(self):
        libqtpythonc.QWidget_adjustSize(self.this)

    def recreate(self,arg0,arg1,arg2,*args):
        apply(libqtpythonc.QWidget_recreate,(self.this,arg0,arg1,arg2,)+args)

    def erase(self):
        libqtpythonc.QWidget_erase(self.this)

    def eraseRect(self,rect):
        libqtpythonc.QWidget_eraseRect(self.this,rect[0],rect[1],rect[2],rect[3])

    def scroll(self,delta):
        libqtpythonc.QWidget_scroll(self.this,delta[0],delta[1])

    def drawText(self,pos,text):
        libqtpythonc.QWidget_drawText(self.this,pos[0],pos[1],text)

    def focusWidget(self):
        val = WidgetPtr(libqtpythonc.QWidget_focusWidget(self.this))
	val.thisown = 0
	return val

    def parentWidget(self):
        val = WidgetPtr(libqtpythonc.QWidget_parentWidget(self.this))
  	val.thisown = 0
	return val

    def __repr__(self):
        return "<Widget instance at %s>" % self.this

class Widget(WidgetPtr):
    def __init__(self,parent="",name="",flags=0) :
	WidgetPtr.__init__(self,"NULL",name)
	if not parent:
            self.this = libqtpythonc.new_QWidget("NULL", name, flags)
            self.thisown = 1
        else:
            self.this = libqtpythonc.new_QWidget(parent.this, name, flags)
	    self.thisown = 0	    


#-------------- FUNCTION WRAPPERS ------------------

Widget_setTabOrder = libqtpythonc.QWidget_setTabOrder

Widget_mouseGrabber = libqtpythonc.QWidget_mouseGrabber

Widget_keyboardGrabber = libqtpythonc.QWidget_keyboardGrabber

Widget_find = libqtpythonc.QWidget_find

Widget_wmapper = libqtpythonc.QWidget_wmapper



#-------------- VARIABLE WRAPPERS ------------------

MacStyle = libqtpythonc.MacStyle
WindowsStyle = libqtpythonc.WindowsStyle
Win3Style = libqtpythonc.Win3Style
PMStyle = libqtpythonc.PMStyle
MotifStyle = libqtpythonc.MotifStyle
