%module KTopwidget


%{
#include <ktopwidget.h>
#include "KMenubar.h"
#include "KStatusbar.h"
#include "KToolbar.h"
%}


%include Types.i
%import KMenubar.i
%import KStatusbar.i
%import KToolbar.i


class KTopLevelWidget : public QWidget 
{
public:
    KTopLevelWidget( const char *name = 0L );
    ~KTopLevelWidget();

    int addToolBar( _ToolBar *toolbar, int index = -1 );
    void setView( QWidget *view, bool show_frame = TRUE );
    void setMenu( _MenuBar *menu );
    void setStatusBar( _StatusBar *statusbar );
    void enableStatusBar( _StatusBar::BarStatus stat = _StatusBar::Toggle );
    void enableToolBar( _ToolBar::BarStatus stat = _ToolBar::Toggle,
                        int ID = 0 );
    void setFrameBorderWidth( int );
    _ToolBar *toolBar( int ID = 0 );
    _MenuBar *menuBar();
    _StatusBar *statusBar();

  static bool canBeRestored(int number);
  static const QString classNameOfToplevel(int number);
  bool restore(int number);
  void setUnsavedData( bool );
};
