%module KMenubar


%{
#include "KMenubar.h"
#include "Popupmenu.h"
%}


%include Types.i
%import Popupmenu.i


class _MenuBar : public QFrame
 {
 public:
   enum menuPosition{Top, Bottom, Floating};

   _MenuBar( QWidget *parent=0, const char *name=0);
   ~_MenuBar();

   void enableMoving(bool flag = TRUE);
   menuPosition menuBarPos();
   void enableFloating (bool flag = TRUE);
   void setMenuBarPos(menuPosition mpos);

   void setTitle(const char *_title);

   unsigned int count();

    int		_insertItem( const char *text,PyObject *slot,int accel=0 );
%name(insertItemAt)   int		insertItem( const char *text, int id=-1, int index=-1 );
%name(popupItemAt)    int		insertItem( const char *text, PopupMenu *popup, int id=-1, int index=-1 );

   void insertSeparator(int index=-1 );
   void removeItem(int id);
   void removeItemAt(int index);
   void clear();
   int accel(int id);
   void setAccel(int key, int id );
   const char *text(int id);
   void changeItem(const char *text, int id);
   void setItemChecked(int id , bool flag);
   void setItemEnabled(int id, bool flag);

   int heightForWidth ( int max_width ) const; 

    void	_connectItem( int id, PyObject *slot);
    void	_disconnectItem( int id, PyObject *slot);

/*     
signals:
    void moved (menuPosition);
    void highlighted(int id);
    void activated(int id);
*/
};
