#ifndef _KLINEEDIT_H_
#define _KLINEEDIT_H_

#include <Python.h>
#include <klined.h>
#include "Baseobject.h"

class _LineEdit : public KLined, public BaseObject
{
  Q_OBJECT	

  public:

    _LineEdit(QWidget *parent=0, const char *name=0) : KLined(parent,name), BaseObject() {
      connect(this, SIGNAL(textChanged(const char *)), this, SLOT(sigTextChanged(const char *)));
      connect(this, SIGNAL(returnPressed()), this, SLOT(sigReturnPressed()));
      connect(this, SIGNAL(completion()), this, SLOT(sigCompletion()));
      connect(this, SIGNAL(rotation()), this, SLOT(sigRotation()));
    };
    ~_LineEdit() {};

  public slots:

    void sigReturnPressed() {
      _emit("returnPressed", 0);
    };
    
    void sigCompletion() {
      _emit("completion", 0);
    };
    
    void sigRotation() {
      _emit("rotation", 0);
    };
    
    void sigTextChanged(const char *text) {
      PyObject *arg = Py_BuildValue("(s)",text);
      _emit("textChanged", arg);
      Py_DECREF(arg);
    };
};    

#endif
