%module Configbase

%{
#include "Object.h"
#include <ksimpleconfig.h>
%}

%include Types.i
%include Constants.i

%import Object.i


class KSimpleConfig : public Object
{
public:

  KSimpleConfig(const char *pFile);
%name(KSimpleConfigReadOnly) KSimpleConfig(const char *pFile, bool ReadOnly);
  virtual ~KSimpleConfig();

  bool isReadOnly();
 
  bool writeConfigFile(QFile & rFile, bool bGlobal = 0);

  const QString deleteEntry(const char *key, bool bLocalized);
  bool deleteGroup(const char *group, bool bDeep=1);
 
  void setGroup( const char* pGroup );
  const char* group();

  const QString readEntry( const char* pKey, const char* pDefault = 0L );
  int readListEntry( const char* pKey, QStrList &list, char sep = ',' );
  int readNumEntry( const char* pKey, int nDefault = 0 );
  unsigned int readUnsignedNumEntry( const char* pKey, unsigned int nDefault = 0 );
  long readLongNumEntry( const char* pKey, long nDefault = 0 );
  unsigned long readUnsignedLongNumEntry( const char* pKey, unsigned long nDefault = 0 ) const;
  double readDoubleNumEntry( const char* pKey, double nDefault = 0 );
  QFont readFontEntry( const char* pKey, const QFont* pDefault = 0L ) const;
  bool readBoolEntry( const char* pKey, const bool bDefault = false ) const;
  QRect readRectEntry( const char* pKey, const QRect* pDefault = 0L ) const;
  QPoint readPointEntry( const char* pKey, const QPoint* pDefault = 0L ) const;
  QSize readSizeEntry( const char* pKey, const QSize* pDefault = 0L ) const;
  QColor readColorEntry( const char* pKey, const QColor* pDefault = 0L ) const;


%name(writeStringEntry)  const char* writeEntry( const char* pKey, const char* pValue,
						  bool bPersistent = true, bool bGlobal = false,
						  bool bNLS = false );
%name(writeListEntry)  void writeEntry ( const char* pKey, QStrList &list, char sep = ',',
					bool bPersistent = true, bool bGlobal = false,
					bool bNLS = false ); 
%name(writeIntEntry)  const char* writeEntry( const char* pKey, long nValue,
						  bool bPersistent = true, bool bGlobal = false,
						  bool bNLS = false ); 
%name(writeFloatEntry)  const char* writeEntry( const char* pKey, double nValue,
						  bool bPersistent = true, bool bGlobal = false,
						  bool bNLS = false ); 
%name(writeBoolEntry)  const char* writeEntry( const char* pKey, bool bValue,
						  bool bPersistent = true, bool bGlobal = false,
						  bool bNLS = false ); 
%name(writeFontEntry)  const char* writeEntry( const char* pKey, const QFont& rFont, 
						  bool bPersistent = true, bool bGlobal = false,
						  bool bNLS = false );
%name(writeColorEntry)  void writeEntry( const char* pKey, const QColor& rColor, 
				   bool bPersistent = true, bool bGlobal = false,
				   bool bNLS = false );
%name(writeRectEntry)  void writeEntry( const char* pKey, const QRect& rColor, 
				   bool bPersistent = true, bool bGlobal = false,
				   bool bNLS = false );
%name(writePointEntry)  void writeEntry( const char* pKey, const QPoint& rColor, 
						  bool bPersistent = true, bool bGlobal = false,
						  bool bNLS = false );
%name(writeSizeEntry)  void writeEntry( const char* pKey, const QSize& rColor, 
						  bool bPersistent = true, bool bGlobal = false,
						  bool bNLS = false );


  virtual void rollback( bool bDeep = true );

  virtual void sync() = 0;

  bool hasKey( const char* pKey ) const;

//  KGroupIterator* groupIterator(void) { return pData->groupIterator(); }

//  KEntryIterator* entryIterator( const char* pGroup );

  virtual void reparseConfiguration();
};