%module Application

%{
#include "KApplication.h"
#include "Application.h"
#include "Baseobject.h"
#include "Object.h"
#include "Popupmenu.h"
%}

%include Types.i
%include Constants.i
%import Application.i
%import Popupmenu.i
%import KIconloader.i
%import Pixmap.i
%import KConfig.i
%import KLocale.i
%import Color.i


// Disable freeing the args, as KApplication only stores a pointer to argv
%typemap(python,freearg) char **;


class _Application : public Application
{
public:
  _Application( int argc, char** argv );
%name(KApplicationName)  _Application( int argc, char** argv, QString rAppName );
  virtual ~_Application();

  virtual bool eventFilter( QObject*, QEvent* );
  static _Application* getKApplication() { return KApp; }

  const QString& appName() const { return aAppName; }

  KConfig* getConfig() const { return pConfig; }
  KConfig* getSessionConfig();

  bool isRestored() const { return bIsRestored; }

  void enableSessionManagement(bool userdefined = FALSE);

  void setWmCommand(const char*);
  
  PopupMenu* getHelpMenu( bool bAboutQtMenu, const char* appAboutText );
							 
  KIconLoader* getIconLoader();
  KLocale* getLocale();
  KCharsets* getCharsets();

  QPixmap getIcon();
  QPixmap getMiniIcon();

  void setTopWidget( QWidget *topWidget );
  QWidget* topWidget();

  void registerTopWidget();
  void unregisterTopWidget();

  enum ConfigState { APPCONFIG_NONE, APPCONFIG_READONLY, 
					 APPCONFIG_READWRITE };
  ConfigState getConfigState() const { return eConfigState; }

  void invokeHTMLHelp( QString aFilename, QString aTopic ) const;

  static const QString& kde_htmldir();
  static const QString& kde_appsdir();
  static const QString& kde_icondir();
  static const QString& kde_datadir();
  static const QString& kde_localedir();
  static const QString& kde_cgidir();
  static const QString& kde_sounddir();
  static const QString& kde_toolbardir();
  static const QString& kde_wallpaperdir();
  static const QString& kde_bindir();
  static const QString& kde_partsdir();
  static const QString& kde_configdir();
  static const QString& kde_mimedir();
  static QString localkdedir();
  static QString localconfigdir();

  static QString findFile( const char *file );

  bool getKDEFonts(QStrList *fontlist);

  const char* getCaption() const;

  const char* tempSaveName( const char* pFilename );

  const char* checkRecoverFile( const char* pFilename, bool& bRecover );

  bool localeConstructed() const { return bLocaleConstructed; }

  Atom getDndSelectionAtom() { return DndSelection; }
  Atom getDndProtocolAtom() { return DndProtocol; }    
  Atom getDndEnterProtocolAtom() { return DndEnterProtocol; }    
  Atom getDndLeaveProtocolAtom() { return DndLeaveProtocol; }    
  Atom getDndRootProtocolAtom() { return DndRootProtocol; }    

  Display *getDisplay() { return display; }

  virtual void addDropZone( KDNDDropZone *_z ) { dropZones.append( _z ); }
  virtual void removeDropZone( KDNDDropZone *_z ) { dropZones.remove( _z ); }
  virtual void setRootDropZone( KDNDDropZone *_z ) { rootDropZone = _z; }

  QColor inactiveTitleColor;
  QColor inactiveTextColor;
  QColor activeTitleColor;
  QColor activeTextColor;
  QColor backgroundColor;
  QColor textColor;
  QColor selectColor;
  QColor selectTextColor;
  QColor windowColor;
  QColor windowTextColor;
  int contrast;
  QFont generalFont;
  QFont fixedFont;
  GUIStyle applicationStyle;

/*
  signals:

  void kdisplayPaletteChanged();
  void kdisplayStyleChanged();
  void kdisplayFontChanged();
  void appearanceChanged();
  void saveYourself();
*/
};
