/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "kllistbox.h"

KLListBox::KLListBox()
{
  setKLWidget(this); 
}

IMPLEMENT_KLMETA_STANDALONE(KLListBox,KLWidgetBase,"ListBox");

bool KLListBox::klShow(KLShowInfo *showInfo)
{
  if( !KLWidgetBase::klShow(showInfo) )
    return false;
  setBackgroundMode( PaletteBase );
  return true;
}


bool KLListBox::klAskMinMax(KLMinMaxSizes *minMaxSizes)
{
  if( !KLWidgetBase::klAskMinMax(minMaxSizes) )
    return false;
  minMaxSizes->minX += 30; // How much space needs a listview to look nice ?
  minMaxSizes->minY += 30; 
  minMaxSizes->defX += 200;
  minMaxSizes->defY += 200;
  minMaxSizes->maxX += KLMaxSize;
  minMaxSizes->maxY += KLMaxSize;
  return true;
}

#include "kllistbox.moc"
