#ifndef __EDITWIDGET_H_
#define __EDITWIDGET_H_

#include <kapp.h>
#include <klocale.h>
//#include <qsplitter.h>
#include <qlistview.h>
#include <qlcdnumber.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qdialog.h>
#include "resource.h"
#include "defines.h"
#include "propwidget.h"



bool isValueTrue(QString val);
int hex2int(QString hex, int pos = 0);

class anItem;
class PropWidget;

class EditWidget : public QWidget
{
  Q_OBJECT
  public:
    EditWidget( PropWidget **pw, QWidget *parent=0, const char *name=0 );

    void insert_item();
    void copy_selected_item() { copyBuffer = activeItem; }
    void paste_item();
    void cut_item();
    anItem *actItem() { return activeItem; }
    void setActItem (anItem *i);

    PropWidget *getPropWidget() { return *propwidget; }
    PropWidget **propwidget;

    anItem *getItem(int nr) { return Items[nr]; }
    int getNumItems() { return numItems; }

    void setActNr(int i) { actNr = i; }
    int getActNr() { return actNr; }

    void selectNext();
    void selectPrev();

  protected:
    void resizeEvent( QResizeEvent * );

    void mouseMoveEvent( QMouseEvent *e );
    void mousePressEvent( QMouseEvent *e );
    void mouseReleaseEvent( QMouseEvent *e );

  private:
    anItem *activeItem;
    anItem *copyBuffer;
    anItem *Items[MAX_WIDGETS];
    int numItems;
    int pressedButton;
    int pressedX, pressedY;
    int wasW, wasH, wasX, wasY;
    int stepX, stepY;
    int steprX, steprY;
    int actNr;
};

struct propItem
{
  QString prop;
  QString value;
  int group;
  int allowed;
};


class dlgInsertItem : public QDialog
{
  Q_OBJECT
  public:
    dlgInsertItem(QWidget *parent);
    int getSelected() { return lbox->currentItem(); }
    int getX() { return QString(led1->text()).toInt(); }
    int getY() { return QString(led2->text()).toInt(); }
    int getW() { return QString(led3->text()).toInt(); }
    int getH() { return QString(led4->text()).toInt(); }
    QString getName() { return led5->text(); }

  protected:
    QListBox *lbox;
    QLineEdit *led1, *led2, *led3, *led4, *led5;
};

class anItem
{
  public:
    anItem( EditWidget *parent, int type, QString Name );
    anItem( EditWidget *parent, anItem *itm );
    ~anItem();

    void setX(int X) { x = X; setPropVal(1,x); }
    void setY(int Y) { y = Y; setPropVal(2,y); }
    void setW(int W) { w = W; setPropVal(3,w); }
    void setH(int H) { h = H; setPropVal(4,h); }
    int X() { return x; }
    int Y() { return y; }
    int W() { return w; }
    int H() { return h; }
    void setName(QString Name) { name = Name; setPropVal(0,Name); }
    QString* Name() { return &name; }
    void setShow(bool s) { bShow = s; setPropVal(5,s); }
    bool isShow() { return bShow; }
//    void setTheItem(QWidget *Item) { theitem = Item; }
//    QWidget *theItem() { return theitem; }
    void createItem();
    void resizeItem(int X, int Y, int W, int H);
    void redoShow();

    propItem *getProp(int i) { return &props[i]; }
    void setProp(int nr, QString prop, QString value) { props[nr].prop=prop; props[nr].value=value; }
    void setPropVal(int nr, QString value) { props[nr].value=value; }
    void setPropVal(int nr, int value) { props[nr].value.setNum(value); }
    void setPropVal(int nr, bool value) { props[nr].value= value?"TRUE":"FALSE"; }
    void refillPropList() {Parent->getPropWidget()->refillList();}
    QString descr(int nr = -1);
    QWidget *getItemsWidget();

    QString getText() { return text; }
    void setText(QString txt);

    int PropsCount() { return nrOfProps; }

    void rebuildFromProps();

//  private:
    EditWidget *Parent;

    int x, y, w, h;
    QString name;
    QString text;
    bool bShow;

    QPushButton  *theitem1;
    QLineEdit    *theitem2;
    QLabel       *theitem3;
    QLCDNumber   *theitem4;
    QCheckBox    *theitem5;
    QRadioButton *theitem6;

    propItem props[64];
    int nrOfProps;
    int Type;
};

#endif // __EDITWIDGET_H_

















