/*
 * Test for KDBM derived by testndbm.c, a driver program to test the ndbm
 * interface routines distributed with gdbm.
 */


#include "kdbm.h"

#include <stdio.h>
//#include <sys/types.h>
//#if HAVE_FILE_H
//#include <sys/file.h>
//#endif
//#include <sys/stat.h>
//#if HAVE_FCNTL_H
//#include <fcntl.h>
//#endif

#define TRUE  1
#define FALSE 0

#define KEY_LINE_SIZE     500
#define DATA_LINE_SIZE    1000

static char key_line[KEY_LINE_SIZE];
static char data_line[DATA_LINE_SIZE];

static void
getkey()
{
  fgets (key_line, KEY_LINE_SIZE, stdin);
  int len = strlen(key_line);

  if (len)
    key_line[len-1] = 0;
}

static void
getdata()
{
  fgets (data_line, DATA_LINE_SIZE, stdin);
  int len = strlen(data_line);

  if (len)
    data_line[len-1] = 0;
}

/* The test program allows one to call all the routines plus the hash function.
   The commands are single letter commands.  The user is prompted for all other
   information.  The commands are q (quit), f (fetch), s (store), d (delete),
   1 (firstkey), n (nextkey) and h (hash function). */

int
main (int argc, char* argv[])
{

  char  cmd_ch;

  char* key_data;
  char* return_data;


  KDbm<char> dbm;

  char done = FALSE;

  char *file_name;

  /* Argument checking. */
  if (argc > 2)
    {
      printf ("Usage: %s [dbm-file] \n",argv[0]);
      exit (2);
    }

  if (argc > 1)
    {
      file_name = argv[1];
    }
  else
    {
      file_name = "testndbm.db";
    }

  dbm.setAccessMode(00664);
  dbm.create(file_name);

  if (!dbm.isOpen)
    {
      printf ("dbm.create() failed.\n");
      exit (2);
    }

  KDbmIterator it(dbm);

  /* Welcome message. */
  printf ("\nWelcome to the KDBM test program.  Type ? for help.\n\n");
  
  while (!done)
    {
      printf ("com -> ");
      cmd_ch = getchar ();
      while (getchar () != '\n') /* Do nothing. */;
      switch (cmd_ch)
	{
	case 'q':
	  done = TRUE;
	  break;

	case 'f':
	  printf ("key -> ");
          getkey();
	  return_data = dbm[key_line];

	  if (return_data != NULL)
	      printf ("data is ->%s\n\n", return_data);
	  else
	    printf ("No such item found.\n\n");
	  break;


	case 's':
	  printf ("key -> ");
	  getkey();
	  printf ("data -> ");
	  getdata();

          if (dbm.replace(key_line, data_line) != 0)
	    printf ("Item not inserted. \n");
	  printf ("\n");
	  break;

	case 'd':
	  printf ("key -> ");
	  getkey();

	  if (dbm.remove(key_line) != 0)
	    printf ("Item not found or deleted\n");
	  printf ("\n");
	  break;

	case '1':
	  key_data = it.getFirstKey();
	  if (key_data != NULL)
	    {
	      return_data = dbm[key_data];
	      printf ("key is ->%s\n", key_data);
	      printf ("data is ->%s\n\n", return_data);
	    }
	  else
	    printf ("No such item found.\n\n");
	  break;


	case '2':
	  key_data = it.getNextKey();
	  if (key_data != NULL)
	    {
	      return_data = dbm[key_data];
	      printf ("key is ->%s\n", key_data);
	      printf ("data is ->%s\n\n", return_data);
	    }
	  else
	    printf ("No such item found.\n\n");
	  break;


	case 'c':
	  {
	    int temp;
	    temp = 0;
	    return_data = it.getFirstKey();
	    while (!it.eof())
	      {
		temp++;
		return_data = it.getNextKey();
	      }
	    printf ("There are %d items in the database.\n\n", temp);
	  }
	  break;

	case '?':
	  printf ("c - count elements\n");
	  printf ("d - delete\n");
	  printf ("f - fetch\n");
	  printf ("q - quit\n");
	  printf ("s - store\n");
	  printf ("1 - firstkey\n");
	  printf ("2 - nextkey on last return value\n\n");
	  break;

	default:
	  printf ("What? \n\n");
	  break;

	}
    }

  /* Quit normally. */
  dbm.close();

  printf("You can remove %s if you don't need it.\n", file_name);

  exit (0);

}
