/*
 * Safely open a temp file
 *
 */

#include <stdio.h>
#include "system.h"

FILE *
safe_fopen(const char *name, const char *mode)
{
	int	fd;

	/* Accept modes w w+ wb etc */
	if (mode[0] != 'w' && mode[0] != 'a') {
		errno = EINVAL;
		return NULL;
	}
	
	if ((fd = open(name, O_RDWR|O_CREAT|O_EXCL, 0600)) < 0)
		return NULL;
	
	return fdopen(fd, mode);
}
